/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.command.internal;

import com.github.darksoulq.abyssallib.common.util.TextUtil;
import com.github.darksoulq.abyssallib.common.util.Try;
import com.github.darksoulq.abyssallib.server.command.Command;
import com.github.darksoulq.abyssallib.server.command.CommandBus;
import com.github.darksoulq.abyssallib.server.event.custom.entity.EntitySpawnEvent;
import com.github.darksoulq.abyssallib.server.registry.Registries;
import com.github.darksoulq.abyssallib.server.resource.util.TextOffset;
import com.github.darksoulq.abyssallib.world.data.statistic.PlayerStatistics;
import com.github.darksoulq.abyssallib.world.data.statistic.Statistic;
import com.github.darksoulq.abyssallib.world.dialog.DialogContent;
import com.github.darksoulq.abyssallib.world.dialog.Dialogs;
import com.github.darksoulq.abyssallib.world.dialog.Notice;
import com.github.darksoulq.abyssallib.world.entity.data.EntityAttributes;
import com.github.darksoulq.abyssallib.world.gui.internal.ItemMenu;
import com.github.darksoulq.abyssallib.world.item.Item;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.FinePositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.EntitySelectorArgumentResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.math.FinePosition;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.kyori.adventure.dialog.DialogLike;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class InternalCommand {
    @Command(name="abyssallib")
    public void register(LiteralArgumentBuilder<CommandSourceStack> root) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.then(((LiteralArgumentBuilder)Commands.literal((String)"give").requires(sender -> sender.getSender().hasPermission("abyssallib.admin.give"))).then(((RequiredArgumentBuilder)Commands.argument((String)"namespace_id", (ArgumentType)ArgumentTypes.namespacedKey()).suggests(InternalCommand::giveSuggests).executes(InternalCommand::giveOneExecutor)).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(InternalCommand::giveMultiExecutor))))).then(((LiteralArgumentBuilder)Commands.literal((String)"attribute").requires(sender -> sender.getSender().hasPermission("abyssallib.admin.attribute"))).then(Commands.literal((String)"get").then(Commands.argument((String)"selector", (ArgumentType)ArgumentTypes.entity()).then(Commands.argument((String)"type", (ArgumentType)ArgumentTypes.namespacedKey()).suggests(InternalCommand::attributeTypeSuggests).executes(InternalCommand::attributeGetExecutor)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"summon").requires(sender -> sender.getSender().hasPermission("abyssallib.admin.summon"))).then(Commands.argument((String)"location", (ArgumentType)ArgumentTypes.finePosition((boolean)false)).then((ArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"namespace_id", (ArgumentType)ArgumentTypes.namespacedKey()).executes(ctx -> {
            try {
                return InternalCommand.summonExecutor((CommandContext<CommandSourceStack>)ctx);
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        })).suggests(InternalCommand::summonSuggests))))).then(((LiteralArgumentBuilder)Commands.literal((String)"statistics").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"get").requires(ctx -> ctx.getSender().hasPermission("abyssallib.player.statistic_self") || ctx.getSender().hasPermission("abyssallib.admin.statistic_all"))).executes(InternalCommand::getSelfStatistics)).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).requires(ctx -> ctx.getSender().hasPermission("abyssallib.admin.statistic_all"))).executes(InternalCommand::getOtherStatistics)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"view").requires(ctx -> {
            Entity sender = InternalCommand.isEntity(ctx);
            if (sender == null) {
                return false;
            }
            return sender.hasPermission("abyssallib.player.statistic_self.menu") || sender.hasPermission("abyssallib.admin.statistic_all.menu");
        })).executes(InternalCommand::getSelfStatisticsMenu)).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).requires(ctx -> {
            Entity sender = InternalCommand.isEntity(ctx);
            if (sender == null) {
                return false;
            }
            return sender.hasPermission("abyssallib.admin.statistic_all.menu");
        })).executes(InternalCommand::getOtherStatisticsMenu))))).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(sender -> sender.getSender().hasPermission("abyssallib.admin.reload"))).then(Commands.literal((String)"commmands").executes(ctx -> {
            CommandBus.reloadAll();
            return 1;
        })))).then(Commands.literal((String)"content").then(((LiteralArgumentBuilder)Commands.literal((String)"items").executes(ctx -> {
            Entity patt0$temp = ((CommandSourceStack)ctx.getSource()).getExecutor();
            if (!(patt0$temp instanceof Player)) {
                ((CommandSourceStack)ctx.getSource()).getSender().sendRichMessage("<red>Only players can run this command</red>");
                return 0;
            }
            Player player = (Player)patt0$temp;
            ItemMenu.open(player);
            return 1;
        })).then(Commands.argument((String)"plugin", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            Set sortedNamespaces = Registries.ITEMS.getAll().keySet().stream().map(key -> key.split(":")[0]).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
            sortedNamespaces.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(ctx -> {
            Entity patt0$temp = ((CommandSourceStack)ctx.getSource()).getExecutor();
            if (!(patt0$temp instanceof Player)) {
                ((CommandSourceStack)ctx.getSource()).getSender().sendRichMessage("<red>Only players can run this command</red>");
                return 0;
            }
            Player player = (Player)patt0$temp;
            String ns = (String)ctx.getArgument("plugin", String.class);
            Item icon = Registries.ITEMS.get(ns + ":plugin_icon");
            if (icon == null) {
                return 1;
            }
            ItemMenu.open(player, ns);
            return 1;
        }))));
    }

    private static int giveOneExecutor(CommandContext<CommandSourceStack> ctx) {
        NamespacedKey namespaceId = (NamespacedKey)ctx.getArgument("namespace_id", NamespacedKey.class);
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        Entity executor = ((CommandSourceStack)ctx.getSource()).getExecutor();
        if (!(executor instanceof Player)) {
            sender.sendPlainMessage("Only a player can run this command!");
            return 1;
        }
        Player player = (Player)executor;
        if (!Registries.ITEMS.contains(namespaceId.asString())) {
            sender.sendPlainMessage("Not an item");
            return 1;
        }
        player.getInventory().addItem(new ItemStack[]{Registries.ITEMS.get(namespaceId.asString()).getStack().clone()});
        return 1;
    }

    private static int giveMultiExecutor(CommandContext<CommandSourceStack> ctx) {
        int amount = (Integer)ctx.getArgument("amount", Integer.TYPE);
        NamespacedKey namespaceId = (NamespacedKey)ctx.getArgument("namespace_id", NamespacedKey.class);
        CommandSender sender = ((CommandSourceStack)ctx.getSource()).getSender();
        Entity executor = ((CommandSourceStack)ctx.getSource()).getExecutor();
        if (!(executor instanceof Player)) {
            sender.sendPlainMessage("Only a player can run this command!");
            return 1;
        }
        Player player = (Player)executor;
        if (!Registries.ITEMS.contains(namespaceId.asString())) {
            sender.sendPlainMessage("Not an item");
            return 1;
        }
        player.getInventory().addItem(new ItemStack[]{Registries.ITEMS.get(namespaceId.asString()).getStack().asQuantity(amount)});
        return 1;
    }

    public static CompletableFuture<Suggestions> giveSuggests(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        for (Item item : Registries.ITEMS.getAll().values()) {
            if (item.getId().getPath().equals("plugin_icon")) continue;
            builder.suggest(item.getId().toString());
        }
        return builder.buildFuture();
    }

    public static int attributeGetExecutor(CommandContext<CommandSourceStack> ctx) {
        NamespacedKey key = (NamespacedKey)ctx.getArgument("type", NamespacedKey.class);
        EntitySelectorArgumentResolver selector = (EntitySelectorArgumentResolver)ctx.getArgument("selector", EntitySelectorArgumentResolver.class);
        try {
            List entities = (List)selector.resolve((CommandSourceStack)ctx.getSource());
            if (!entities.isEmpty()) {
                EntityAttributes data = EntityAttributes.of((Entity)entities.getFirst());
                data.load();
                Map<String, String> attribMap = data.getAllAttributes();
                if (attribMap.containsKey(key.toString())) {
                    ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(key.toString() + ": " + attribMap.get(key.toString()));
                }
            }
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        return 1;
    }

    public static CompletableFuture<Suggestions> attributeTypeSuggests(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        EntitySelectorArgumentResolver selector = (EntitySelectorArgumentResolver)ctx.getArgument("selector", EntitySelectorArgumentResolver.class);
        try {
            List entities = (List)selector.resolve((CommandSourceStack)ctx.getSource());
            if (!entities.isEmpty()) {
                EntityAttributes data = EntityAttributes.of((Entity)entities.getFirst());
                data.load();
                for (String attrib : data.getAllAttributes().keySet()) {
                    builder.suggest(attrib);
                }
                return builder.buildFuture();
            }
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        return builder.buildFuture();
    }

    public static int summonExecutor(CommandContext<CommandSourceStack> ctx) throws CloneNotSupportedException, CommandSyntaxException {
        FinePositionResolver position = (FinePositionResolver)ctx.getArgument("location", FinePositionResolver.class);
        Entity sender = InternalCommand.isEntity((CommandSourceStack)ctx.getSource());
        if (sender == null) {
            return 1;
        }
        Location loc = ((FinePosition)position.resolve((CommandSourceStack)ctx.getSource())).toLocation(sender.getWorld());
        NamespacedKey id = (NamespacedKey)ctx.getArgument("namespace_id", NamespacedKey.class);
        if (!Registries.ENTITIES.contains(id.asString())) {
            sender.sendPlainMessage("Not an entity");
            return 1;
        }
        ((com.github.darksoulq.abyssallib.world.entity.Entity)Registries.ENTITIES.get(id.asString()).clone()).spawn(loc, EntitySpawnEvent.SpawnReason.PLUGIN);
        return 1;
    }

    public static CompletableFuture<Suggestions> summonSuggests(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        for (com.github.darksoulq.abyssallib.world.entity.Entity<? extends LivingEntity> entity : Registries.ENTITIES.getAll().values()) {
            builder.suggest(entity.getId().toString());
        }
        return builder.buildFuture();
    }

    public static int getSelfStatistics(CommandContext<CommandSourceStack> ctx) {
        Entity sender = InternalCommand.isEntity((CommandSourceStack)ctx.getSource());
        if (!(sender instanceof Player)) {
            return 1;
        }
        Player player = (Player)sender;
        InternalCommand.handleSendStats(player, ctx);
        return 1;
    }

    public static int getOtherStatistics(CommandContext<CommandSourceStack> ctx) {
        PlayerSelectorArgumentResolver playerResolver = (PlayerSelectorArgumentResolver)ctx.getArgument("player", PlayerSelectorArgumentResolver.class);
        Player player = Try.get(() -> (Player)((List)playerResolver.resolve((CommandSourceStack)ctx.getSource())).getFirst(), (Player)null);
        if (player == null) {
            return 1;
        }
        InternalCommand.handleSendStats(player, ctx);
        return 1;
    }

    public static int getSelfStatisticsMenu(CommandContext<CommandSourceStack> ctx) {
        Entity sender = InternalCommand.isEntity((CommandSourceStack)ctx.getSource());
        if (!(sender instanceof Player)) {
            return 1;
        }
        Player player = (Player)sender;
        player.showDialog((DialogLike)InternalCommand.createStatDialog(player));
        return 1;
    }

    public static int getOtherStatisticsMenu(CommandContext<CommandSourceStack> ctx) {
        PlayerSelectorArgumentResolver playerResolver = (PlayerSelectorArgumentResolver)ctx.getArgument("player", PlayerSelectorArgumentResolver.class);
        Player player = Try.get(() -> (Player)((List)playerResolver.resolve((CommandSourceStack)ctx.getSource())).getFirst(), (Player)null);
        if (player == null) {
            return 1;
        }
        Entity entity = InternalCommand.isEntity((CommandSourceStack)ctx.getSource());
        if (!(entity instanceof Player)) {
            return 1;
        }
        Player viewer = (Player)entity;
        viewer.showDialog((DialogLike)InternalCommand.createStatDialog(player));
        return 1;
    }

    private static Entity isEntity(CommandSourceStack ctx) {
        CommandSender sender;
        Object object = sender = ctx.getExecutor() == null ? ctx.getSender() : ctx.getExecutor();
        if (!(sender instanceof Entity)) {
            return null;
        }
        Entity entity = (Entity)sender;
        return entity;
    }

    private static void handleSendStats(Player player, CommandContext<CommandSourceStack> ctx) {
        PlayerStatistics stats = PlayerStatistics.of(player);
        StringBuilder sb = new StringBuilder();
        List<Statistic> list = stats.get();
        if (list.isEmpty()) {
            sb.append("<gray>No statistics found.</gray>");
        }
        for (Statistic stat : list) {
            String langKey = "<lang:%s.stat.%s>".formatted(stat.getId().getNamespace(), stat.getId().getPath());
            sb.append("<aqua>").append(langKey).append("</aqua> <gray>=</gray> <yellow>").append(stat.getValue()).append("</yellow>\n");
        }
        ((CommandSourceStack)ctx.getSource()).getSender().sendRichMessage(sb.toString());
    }

    private static Dialog createStatDialog(Player player) {
        Notice dialog = Dialogs.notice(TextUtil.parse("Statistics"));
        PlayerStatistics stats = PlayerStatistics.of(player);
        if (stats.get().isEmpty()) {
            dialog.body((DialogBody)DialogContent.text(TextUtil.parse("<gray>No statistics found.</gray>")));
        }
        for (Statistic stat : stats.get()) {
            String langKey = "<lang:%s.stat.%s>".formatted(stat.getId().getNamespace(), stat.getId().getPath());
            dialog.body((DialogBody)DialogContent.text(TextUtil.parse(TextOffset.getOffsetMinimessage(40) + langKey + " = " + String.valueOf(stat.getValue()))));
        }
        return dialog.build();
    }
}

