/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.event.internal;

import com.destroystokyo.paper.event.player.PlayerAdvancementCriterionGrantEvent;
import com.github.darksoulq.abyssallib.server.event.ActionResult;
import com.github.darksoulq.abyssallib.server.event.SubscribeEvent;
import com.github.darksoulq.abyssallib.world.gui.GuiElement;
import com.github.darksoulq.abyssallib.world.gui.GuiFlag;
import com.github.darksoulq.abyssallib.world.gui.GuiManager;
import com.github.darksoulq.abyssallib.world.gui.GuiView;
import java.util.Iterator;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;

public class GuiEvents {
    @SubscribeEvent(ignoreCancelled=false)
    public void onDropPickup(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            GuiView view = GuiManager.openViews.get(player.getOpenInventory());
            if (view == null) {
                return;
            }
            if (view.getGui().hasFlag(GuiFlag.DISABLE_ITEM_PICKUP)) {
                event.setCancelled(true);
            }
        }
    }

    @SubscribeEvent(ignoreCancelled=false)
    public void onCriterionGrant(PlayerAdvancementCriterionGrantEvent event) {
        GuiView view = GuiManager.openViews.get(event.getPlayer().getOpenInventory());
        if (view == null) {
            return;
        }
        if (view.getGui().hasFlag(GuiFlag.DISABLE_ADVANCEMENTS)) {
            event.setCancelled(true);
        }
    }

    @SubscribeEvent(ignoreCancelled=false)
    public void onClick(InventoryClickEvent event) {
        GuiView.Segment segment;
        GuiView view = GuiManager.openViews.get(event.getView());
        if (view == null) {
            return;
        }
        int rawSlot = event.getRawSlot();
        boolean top = rawSlot < view.getTop().getSize();
        GuiView.Segment segment2 = segment = top ? GuiView.Segment.TOP : GuiView.Segment.BOTTOM;
        if (top && view.getGui().hasFlag(GuiFlag.DISABLE_TOP)) {
            return;
        }
        if (!top && view.getGui().hasFlag(GuiFlag.DISABLE_BOTTOM)) {
            return;
        }
        int slot = event.getSlot();
        GuiElement element = view.getElementAt(segment, slot);
        if (element == null) {
            event.setCancelled(true);
            return;
        }
        ActionResult result = element.onClick(view, slot, event.getClick(), event.getCursor(), event.getCurrentItem());
        event.setCancelled(result == ActionResult.CANCEL);
    }

    @SubscribeEvent(ignoreCancelled=false)
    public void onDrag(InventoryDragEvent event) {
        GuiView view = GuiManager.openViews.get(event.getView());
        if (view == null) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot;
            GuiElement el;
            GuiView.Segment segment;
            int rawSlot = (Integer)iterator.next();
            boolean top = rawSlot < view.getTop().getSize();
            GuiView.Segment segment2 = segment = top ? GuiView.Segment.TOP : GuiView.Segment.BOTTOM;
            if (top && view.getGui().hasFlag(GuiFlag.DISABLE_TOP) || !top && view.getGui().hasFlag(GuiFlag.DISABLE_BOTTOM) || (el = view.getElementAt(segment, slot = view.getInventoryView().convertSlot(rawSlot))) != null && el.onDrag(view, event.getNewItems()) != ActionResult.CANCEL) continue;
            event.setCancelled(true);
        }
    }

    @SubscribeEvent(ignoreCancelled=false)
    public void onClose(InventoryCloseEvent event) {
        GuiView view = GuiManager.openViews.remove(event.getView());
        if (view != null) {
            view.getGui().getOnClose().accept(view);
        }
    }
}

