/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.event.internal;

import com.github.darksoulq.abyssallib.AbyssalLib;
import com.github.darksoulq.abyssallib.server.command.CommandBus;
import com.github.darksoulq.abyssallib.server.command.internal.InternalCommand;
import com.github.darksoulq.abyssallib.server.event.SubscribeEvent;
import com.github.darksoulq.abyssallib.world.block.internal.BlockManager;
import com.github.darksoulq.abyssallib.world.data.internal.MapLoader;
import com.github.darksoulq.abyssallib.world.data.statistic.PlayerStatistics;
import com.github.darksoulq.abyssallib.world.data.tag.TagLoader;
import com.github.darksoulq.abyssallib.world.entity.data.EntityAttributes;
import com.github.darksoulq.abyssallib.world.entity.internal.EntityManager;
import com.github.darksoulq.abyssallib.world.recipe.RecipeLoader;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ServerEvents {
    @SubscribeEvent(ignoreCancelled=false)
    public void onServerLoad(ServerLoadEvent e) {
        if (e.getType() == ServerLoadEvent.LoadType.STARTUP) {
            new BukkitRunnable(this){

                public void run() {
                    MapLoader.load();
                    CommandBus.register("abyssallib", new InternalCommand());
                    BlockManager.load();
                    EntityManager.load();
                    EntityManager.restoreEntities();
                    EntityAttributes.init();
                    PlayerStatistics.init();
                    RecipeLoader.reload();
                    TagLoader.loadTags();
                }
            }.runTaskLater((Plugin)AbyssalLib.getInstance(), 10L);
        }
        if (e.getType() == ServerLoadEvent.LoadType.RELOAD) {
            new BukkitRunnable(this){

                public void run() {
                    RecipeLoader.reload();
                }
            }.runTaskLater((Plugin)AbyssalLib.getInstance(), 10L);
        }
    }
}

