/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.resource;

import com.github.darksoulq.abyssallib.AbyssalLib;
import com.github.darksoulq.abyssallib.common.util.FileUtils;
import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.github.darksoulq.abyssallib.server.HookConstants;
import com.github.darksoulq.abyssallib.server.event.EventBus;
import com.github.darksoulq.abyssallib.server.event.custom.server.ResourcePackGenerateEvent;
import com.github.darksoulq.abyssallib.server.registry.Registries;
import com.github.darksoulq.abyssallib.server.resource.Namespace;
import com.github.darksoulq.abyssallib.server.resource.asset.Icon;
import com.github.darksoulq.abyssallib.server.resource.asset.Model;
import com.github.darksoulq.abyssallib.server.resource.asset.PackMcMeta;
import com.github.darksoulq.abyssallib.server.resource.asset.Texture;
import com.github.darksoulq.abyssallib.server.resource.asset.definition.Selector;
import com.github.darksoulq.abyssallib.server.resource.asset.definition.Tint;
import com.github.darksoulq.abyssallib.world.item.Item;
import com.github.darksoulq.abyssallib.world.item.component.builtin.ItemModel;
import com.magmaguy.resourcepackmanager.api.ResourcePackManagerAPI;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.kyori.adventure.key.Key;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ResourcePack {
    public static final Map<String, ResourcePack> CACHED = new HashMap<String, ResourcePack>();
    private final Plugin plugin;
    private final String pluginId;
    private final Path outputFile;
    private Icon icon = null;
    private PackMcMeta mcMeta = null;
    private final Map<String, byte[]> files = new TreeMap<String, byte[]>();
    private final Map<String, Namespace> namespaces = new HashMap<String, Namespace>();
    public static final Map<String, UUID> UUID_MAP = new HashMap<String, UUID>();
    public static final Map<String, String> HASH_MAP = new HashMap<String, String>();

    public ResourcePack(@NotNull Plugin plugin, @NotNull String pluginId) {
        this.plugin = plugin;
        this.pluginId = pluginId;
        this.outputFile = plugin.getDataFolder().toPath().resolve("pack").resolve("resourcepack.zip");
        UUID_MAP.put(pluginId, UUID.randomUUID());
    }

    @NotNull
    public Namespace namespace(@NotNull String namespace) {
        return this.namespaces.computeIfAbsent(namespace, ns -> new Namespace((String)ns, this));
    }

    public void icon(byte[] data) {
        this.icon = new Icon(data);
    }

    public void icon() {
        this.icon = new Icon(this.plugin);
    }

    public void mcmeta(PackMcMeta mcmeta) {
        this.mcMeta = mcmeta;
    }

    @NotNull
    public Collection<Namespace> getNamespaces() {
        return this.namespaces.values();
    }

    @NotNull
    public Path getOutputFile() {
        return this.outputFile;
    }

    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    public void compile(boolean override) {
        CACHED.put(this.pluginId, this);
        if (!override && this.outputFile.toFile().exists()) {
            HASH_MAP.put(this.pluginId, FileUtils.sha1(this.outputFile));
            for (Namespace ns : this.namespaces.values()) {
                Item icon = new Item(Identifier.of(ns.getNamespace(), "plugin_icon"), Material.GRASS_BLOCK);
                if (ns.getIcon() == null) {
                    icon.setData(new ItemModel((Key)NamespacedKey.fromString((String)"apple")));
                }
                Registries.ITEMS.register(icon.getId().toString(), icon);
            }
            return;
        }
        this.files.clear();
        for (Namespace ns : this.namespaces.values()) {
            Item icon = new Item(Identifier.of(ns.getNamespace(), "plugin_icon"), Material.GRASS_BLOCK);
            Texture nsIcon = ns.getIcon();
            if (nsIcon == null) {
                icon.setData(new ItemModel((Key)NamespacedKey.fromString((String)"apple")));
            } else {
                nsIcon.emit(this.files);
                Model model = ns.model("plugin_icon", false);
                model.parent("builtin/generated");
                model.texture("layer0", nsIcon);
                Selector.Model sel = new Selector.Model(model, new Tint[0]);
                ns.itemDefinition("plugin_icon", sel);
            }
            Registries.ITEMS.register(icon.getId().toString(), icon);
            ns.emit(this.files);
        }
        if (this.mcMeta != null) {
            this.mcMeta.emit(this.files);
        } else {
            this.put("pack.mcmeta", this.generatePackMeta());
        }
        if (this.icon != null) {
            this.icon.emit(this.files);
        }
        try {
            Files.createDirectories(this.outputFile.getParent(), new FileAttribute[0]);
            try (ZipOutputStream zip = new ZipOutputStream(Files.newOutputStream(this.outputFile, new OpenOption[0]));){
                for (Map.Entry<String, byte[]> entry : this.files.entrySet()) {
                    zip.putNextEntry(new ZipEntry(entry.getKey()));
                    zip.write(entry.getValue());
                    zip.closeEntry();
                }
            }
            HASH_MAP.put(this.pluginId, FileUtils.sha1(this.outputFile));
            EventBus.post(new ResourcePackGenerateEvent(this.pluginId, this.outputFile.toFile()));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write resource pack: " + String.valueOf(this.outputFile), e);
        }
    }

    public void register(boolean override) {
        this.compile(override);
        if (AbyssalLib.PACK_SERVER != null) {
            AbyssalLib.PACK_SERVER.registerResourcePack(this.pluginId, this.outputFile);
        } else if (HookConstants.isEnabled(HookConstants.Plugin.RSPM)) {
            ResourcePackManagerAPI.registerLocalResourcePack((String)this.plugin.getName(), (String)(this.plugin.getName() + "/pack/resourcepack.zip"), (boolean)false, (boolean)true, (boolean)true, null);
        }
    }

    public void unregister() {
        if (AbyssalLib.PACK_SERVER != null) {
            AbyssalLib.PACK_SERVER.unregisterResourcePack(this.pluginId);
        }
    }

    protected void put(@NotNull String path, byte @NotNull [] data) {
        this.files.put(path, data);
    }

    protected void put(@NotNull String path, @NotNull String text) {
        this.files.put(path, text.getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    private String generatePackMeta() {
        return "{\n  \"pack\": {\n    \"pack_format\": 55,\n    \"description\": \"" + this.pluginId + " internal Resource Pack\"\n  }\n}";
    }
}

