/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.resource.asset;

import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.github.darksoulq.abyssallib.server.resource.asset.Asset;
import com.github.darksoulq.abyssallib.server.resource.asset.Texture;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.apache.fontbox.ttf.CmapSubtable;
import org.apache.fontbox.ttf.CmapTable;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class Font
implements Asset {
    private final String namespace;
    private final String id;
    private final List<LinkedList<Glyph>> glyphGroups = new LinkedList<LinkedList<Glyph>>();
    private final Set<Character> occupied = new HashSet<Character>();
    private int unicodeBase = 57344;
    private byte[] rawData = null;

    public Font(@NotNull String namespace, @NotNull String id) {
        this.namespace = namespace;
        this.id = id;
    }

    public Font(@NotNull String namespace, @NotNull String id, byte[] data) {
        this.namespace = namespace;
        this.id = id;
        this.rawData = data;
    }

    public Font(@NotNull Plugin plugin, @NotNull String namespace, @NotNull String id) {
        this.namespace = namespace;
        this.id = id;
        String path = "resourcepack/" + namespace + "/font/" + id + ".json";
        try (InputStream in = plugin.getResource(path);){
            if (in == null) {
                throw new IllegalStateException("Font not found: " + path);
            }
            JsonArray providers = JsonParser.parseReader((Reader)new InputStreamReader(in, StandardCharsets.UTF_8)).getAsJsonObject().getAsJsonArray("providers");
            for (JsonElement el : providers) {
                JsonArray chars;
                JsonObject p = el.getAsJsonObject();
                if (!"bitmap".equals(p.get("type").getAsString()) || (chars = p.getAsJsonArray("chars")).size() != 1 || chars.get(0).getAsString().length() != 1) continue;
                String file = p.get("file").getAsString().replaceFirst("\\.png$", "");
                int h = p.has("height") ? p.get("height").getAsInt() : 8;
                int a = p.has("ascent") ? p.get("ascent").getAsInt() : h;
                char c = chars.get(0).getAsString().charAt(0);
                Texture tex = new Texture(plugin, namespace, file);
                this.addTextureGlyph(tex, c, h, a);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public OffsetGlyph offset(int pixelOffset, char unicode) {
        OffsetGlyph g = new OffsetGlyph(Identifier.of(this.namespace, this.id), unicode, pixelOffset);
        LinkedList<OffsetGlyph> list = new LinkedList<OffsetGlyph>();
        list.add(g);
        this.glyphGroups.add(list);
        return g;
    }

    public void ttf(@NotNull File ttfFile, int shiftX, int shiftY, int size, int oversample) throws IOException {
        Set<Character> chars = this.readTtfUnicodes(ttfFile);
        for (char c : chars) {
            this.ensureNotOccupied(c);
        }
        this.occupied.addAll(chars);
        LinkedList<TtfFont> gl = new LinkedList<TtfFont>();
        gl.add(new TtfFont(Identifier.of(this.namespace, this.id), ttfFile.getPath(), shiftX, shiftY, size, oversample));
        this.glyphGroups.add(gl);
    }

    public void unihex(@NotNull File zipFile, @NotNull List<UnihexFont.Override> overrides) throws IOException {
        Set<Character> chars = this.readUnihexUnicodes(zipFile);
        for (char c : chars) {
            this.ensureNotOccupied(c);
        }
        this.occupied.addAll(chars);
        LinkedList<UnihexFont> gl = new LinkedList<UnihexFont>();
        gl.add(new UnihexFont(Identifier.of(this.namespace, this.id), zipFile.getPath(), overrides));
        this.glyphGroups.add(gl);
    }

    @NotNull
    public TextureGlyph glyph(Texture texture, int height, int ascent) {
        char c = this.nextUnicode();
        TextureGlyph g = new TextureGlyph(Identifier.of(this.namespace, this.id), texture, c, height, ascent);
        LinkedList<TextureGlyph> gl = new LinkedList<TextureGlyph>();
        gl.add(g);
        this.occupied.add(Character.valueOf(c));
        this.glyphGroups.add(gl);
        return g;
    }

    @NotNull
    public List<LinkedList<Glyph>> glyphs(@NotNull Texture texture, int spriteW, int spriteH, int height, int ascent) {
        int[] size = this.getImageSize(texture.data());
        int textureWidth = size[0];
        int textureHeight = size[1];
        ArrayList<LinkedList<Glyph>> result = new ArrayList<LinkedList<Glyph>>();
        int cols = textureWidth / spriteW;
        int rows = textureHeight / spriteH;
        for (int r = 0; r < rows; ++r) {
            LinkedList<TextureGlyph> line = new LinkedList<TextureGlyph>();
            for (int c = 0; c < cols; ++c) {
                char ch = this.nextUnicode();
                TextureGlyph tg = new TextureGlyph(Identifier.of(this.namespace, this.id), texture, ch, height, ascent);
                line.add(tg);
                this.occupied.add(Character.valueOf(ch));
            }
            result.add(line);
            this.glyphGroups.add(line);
        }
        return result;
    }

    @Override
    public void emit(@NotNull Map<String, byte[]> files) {
        Glyph first;
        if (this.rawData != null) {
            files.put("assets/" + this.namespace + "/font/" + this.id + ".json", this.rawData);
            return;
        }
        JsonArray providers = new JsonArray();
        LinkedHashMap<BitmapKey, LinkedList> bitmapGroups = new LinkedHashMap<BitmapKey, LinkedList>();
        LinkedList<OffsetGlyph> spaces = new LinkedList<OffsetGlyph>();
        for (LinkedList<Glyph> group : this.glyphGroups) {
            if (group.isEmpty() || !((first = group.getFirst()) instanceof OffsetGlyph)) continue;
            group.forEach(g -> spaces.add((OffsetGlyph)g));
        }
        for (LinkedList<Glyph> group : this.glyphGroups) {
            if (group.isEmpty()) continue;
            first = group.getFirst();
            if (first instanceof TextureGlyph) {
                for (Glyph g2 : group) {
                    TextureGlyph t = (TextureGlyph)g2;
                    BitmapKey key2 = new BitmapKey(t.texture(), t.height(), t.ascent());
                    bitmapGroups.computeIfAbsent(key2, k -> new LinkedList()).add(t);
                }
                continue;
            }
            if (first instanceof TtfFont) {
                TtfFont ttf = (TtfFont)first;
                providers.add((JsonElement)ttf.toJson());
                continue;
            }
            if (!(first instanceof UnihexFont)) continue;
            UnihexFont unihex = (UnihexFont)first;
            providers.add((JsonElement)unihex.toJson());
        }
        if (!spaces.isEmpty()) {
            providers.add((JsonElement)this.toSpaceProvider(spaces));
        }
        bitmapGroups.forEach((key, glyphs) -> providers.add((JsonElement)this.toBitmapProvider((List<TextureGlyph>)glyphs, (BitmapKey)key)));
        JsonObject root = new JsonObject();
        root.add("providers", (JsonElement)providers);
        files.put("assets/" + this.namespace + "/font/" + this.id + ".json", new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)root).getBytes(StandardCharsets.UTF_8));
    }

    private JsonObject toBitmapProvider(List<TextureGlyph> list, BitmapKey key) {
        JsonObject provider = new JsonObject();
        provider.addProperty("type", "bitmap");
        provider.addProperty("file", key.texture().file() + ".png");
        provider.addProperty("height", (Number)key.height());
        provider.addProperty("ascent", (Number)key.ascent());
        JsonArray chars = new JsonArray();
        for (TextureGlyph glyph : list) {
            chars.add(String.valueOf(glyph.character()));
        }
        provider.add("chars", (JsonElement)chars);
        return provider;
    }

    private JsonObject toSpaceProvider(List<OffsetGlyph> list) {
        JsonObject p = new JsonObject();
        p.addProperty("type", "space");
        JsonObject adv = new JsonObject();
        list.forEach(o -> adv.addProperty(String.valueOf(o.character()), (Number)o.advance()));
        p.add("advances", (JsonElement)adv);
        return p;
    }

    private char nextUnicode() {
        while (this.unicodeBase <= 63743) {
            char c;
            if (this.occupied.contains(Character.valueOf(c = (char)this.unicodeBase++))) continue;
            return c;
        }
        throw new IllegalStateException("PUA exhausted");
    }

    private void addTextureGlyph(@NotNull Texture texture, char c, int h, int a) {
        TextureGlyph g = new TextureGlyph(Identifier.of(this.namespace, this.id), texture, c, h, a);
        LinkedList<TextureGlyph> list = new LinkedList<TextureGlyph>();
        list.add(g);
        this.glyphGroups.add(list);
        this.occupied.add(Character.valueOf(c));
    }

    private void ensureNotOccupied(char c) {
        if (this.occupied.contains(Character.valueOf(c))) {
            throw new IllegalStateException("Unicode U+" + Integer.toHexString(c).toUpperCase() + " already occupied");
        }
    }

    private int[] getImageSize(byte[] imageData) {
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageData));
            if (image == null) {
                throw new IllegalArgumentException("Invalid image data.");
            }
            return new int[]{image.getWidth(), image.getHeight()};
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read image dimensions", e);
        }
    }

    private Set<Character> readTtfUnicodes(File file) throws IOException {
        HashSet<Character> set = new HashSet<Character>();
        try (TrueTypeFont ttf = new TTFParser().parse((RandomAccessRead)new RandomAccessReadBufferedFile(file));){
            CmapTable cmapTable = ttf.getCmap();
            if (cmapTable != null) {
                for (CmapSubtable cmap : cmapTable.getCmaps()) {
                    for (int cp = 0; cp <= 65535; ++cp) {
                        int gid = cmap.getGlyphId(cp);
                        if (gid <= 0) continue;
                        set.add(Character.valueOf((char)cp));
                    }
                }
            }
        }
        return set;
    }

    private Set<Character> readUnihexUnicodes(File zip) throws IOException {
        HashSet<Character> set = new HashSet<Character>();
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zip));){
            ZipEntry e;
            while ((e = zis.getNextEntry()) != null) {
                String name = new File(e.getName()).getName();
                if (!name.matches("[0-9A-Fa-f]{4,6}\\.hex")) continue;
                int cp = Integer.parseInt(name.replace(".hex", ""), 16);
                set.add(Character.valueOf((char)cp));
            }
        }
        return set;
    }

    public record OffsetGlyph(Identifier fontId, char character, int advance) implements Glyph
    {
        public TextComponent toComponent() {
            return (TextComponent)Component.text((char)this.character).font((Key)this.fontId.asNamespacedKey());
        }

        public String toMiniMessageString() {
            return "<font:" + this.fontId.toString() + ">" + this.character + "</font>";
        }
    }

    public record TtfFont(Identifier fontId, String file, int shiftX, int shiftY, int size, int oversample) implements Glyph
    {
        public JsonObject toJson() {
            JsonObject p = new JsonObject();
            p.addProperty("type", "ttf");
            p.addProperty("file", this.file);
            p.addProperty("size", (Number)this.size);
            p.addProperty("oversample", (Number)this.oversample);
            JsonArray shift = new JsonArray();
            shift.add((Number)this.shiftX);
            shift.add((Number)this.shiftY);
            p.add("shift", (JsonElement)shift);
            return p;
        }
    }

    public record UnihexFont(Identifier fontId, String file, List<Override> sizeOverrides) implements Glyph
    {
        public JsonObject toJson() {
            JsonObject p = new JsonObject();
            p.addProperty("type", "unihex");
            p.addProperty("hex_file", this.file);
            JsonArray arr = new JsonArray();
            for (Override o : this.sizeOverrides) {
                JsonObject j = new JsonObject();
                j.addProperty("from", (Number)o.from());
                j.addProperty("to", (Number)o.to());
                j.addProperty("left", (Number)o.left());
                j.addProperty("right", (Number)o.right());
                arr.add((JsonElement)j);
            }
            p.add("size_overrides", (JsonElement)arr);
            return p;
        }

        public record Override(int from, int to, int left, int right) {
        }
    }

    public record TextureGlyph(Identifier fontId, @NotNull Texture texture, char character, int height, int ascent) implements Glyph
    {
        public TextComponent toComponent() {
            return (TextComponent)Component.text((char)this.character).font((Key)this.fontId.asNamespacedKey());
        }

        public String toMiniMessageString() {
            return "<font:" + this.fontId.toString() + ">" + this.character + "</font>";
        }
    }

    public static sealed interface Glyph
    permits TextureGlyph, OffsetGlyph, TtfFont, UnihexFont {
    }

    private record BitmapKey(Texture texture, int height, int ascent) {
    }
}

