/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.resource.asset.definition;

import com.github.darksoulq.abyssallib.server.resource.asset.Texture;
import com.github.darksoulq.abyssallib.server.resource.asset.definition.ContainedComponent;
import com.github.darksoulq.abyssallib.server.resource.asset.definition.HeadType;
import com.github.darksoulq.abyssallib.server.resource.asset.definition.NamedColor;
import com.github.darksoulq.abyssallib.server.resource.asset.definition.Orientation;
import com.github.darksoulq.abyssallib.server.resource.asset.definition.Tint;
import com.github.darksoulq.abyssallib.server.resource.asset.definition.WoodType;
import java.lang.runtime.SwitchBootstraps;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public interface Selector {
    public String id();

    public Map<String, Object> toJson();

    public static class Special
    implements Selector {
        private final com.github.darksoulq.abyssallib.server.resource.asset.Model base;
        private final Type type;

        public Special(com.github.darksoulq.abyssallib.server.resource.asset.Model base, Type type) {
            this.base = base;
            this.type = type;
        }

        @Override
        public String id() {
            return "minecraft:special";
        }

        @Override
        public Map<String, Object> toJson() {
            HashMap<String, Object> json = new HashMap<String, Object>();
            json.put("type", this.id());
            json.put("model", this.type.toJson());
            json.put("base", this.base.file());
            return json;
        }

        public static interface Type {
            public String id();

            public Map<String, Object> toJson();
        }

        public static class Trident
        implements Type {
            @Override
            public String id() {
                return "minecraft:trident";
            }

            @Override
            public Map<String, Object> toJson() {
                return Map.of("type", this.id());
            }
        }

        public static class StandingSign
        implements Type {
            private final WoodType type;
            private final Texture texture;

            public StandingSign(WoodType type, Texture texture) {
                this.type = type;
                this.texture = texture;
            }

            @Override
            public String id() {
                return "minecraft:standing_sign";
            }

            @Override
            public Map<String, Object> toJson() {
                HashMap<String, Object> json = new HashMap<String, Object>();
                json.put("type", this.id());
                json.put("wood_type", this.type.name().toLowerCase());
                json.put("texture", this.texture.file());
                return json;
            }
        }

        public static class ShulkerBox
        implements Type {
            private final Texture texture;
            private final int openness;
            private final Orientation orientaion;

            public ShulkerBox(Texture texture, int openness, Orientation orientaion) {
                this.texture = texture;
                this.openness = openness;
                this.orientaion = orientaion;
            }

            @Override
            public String id() {
                return "minecraft:shulker_box";
            }

            @Override
            public Map<String, Object> toJson() {
                HashMap<String, Object> json = new HashMap<String, Object>();
                json.put("type", this.id());
                json.put("texture", this.texture.file());
                json.put("openness", this.openness);
                json.put("orientation", this.orientaion.name().toLowerCase());
                return json;
            }
        }

        public static class Shield
        implements Type {
            @Override
            public String id() {
                return "minecraft:shield";
            }

            @Override
            public Map<String, Object> toJson() {
                return Map.of("type", this.id());
            }
        }

        public static class Head
        implements Type {
            private final HeadType kind;
            private final Texture texture;
            private final int animationTime;

            public Head(HeadType kind, @Nullable Texture texture, int animationTime) {
                this.kind = kind;
                this.texture = texture;
                this.animationTime = animationTime;
            }

            @Override
            public String id() {
                return "minecraft:head";
            }

            @Override
            public Map<String, Object> toJson() {
                HashMap<String, Object> json = new HashMap<String, Object>();
                json.put("type", this.id());
                json.put("kind", this.kind.name().toLowerCase());
                if (this.texture != null) {
                    json.put("texture", this.texture.file());
                }
                if (this.kind.equals((Object)HeadType.DRAGON) || this.kind.equals((Object)HeadType.PIGLIN)) {
                    json.put("animation", this.animationTime);
                }
                return json;
            }
        }

        public static class HangingSign
        implements Type {
            private final WoodType type;
            private final Texture texture;

            public HangingSign(WoodType type, Texture texture) {
                this.type = type;
                this.texture = texture;
            }

            @Override
            public String id() {
                return "minecraft:hanging_sign";
            }

            @Override
            public Map<String, Object> toJson() {
                HashMap<String, Object> json = new HashMap<String, Object>();
                json.put("type", this.id());
                json.put("wood_type", this.type.name().toLowerCase());
                json.put("texture", this.texture.file());
                return json;
            }
        }

        public static class DecoratedPot
        implements Type {
            @Override
            public String id() {
                return "minecraft:decorated_pot";
            }

            @Override
            public Map<String, Object> toJson() {
                return Map.of("type", this.id());
            }
        }

        public static class Chest
        implements Type {
            private final Texture texture;
            private final int openness;

            public Chest(Texture texture, int openness) {
                this.texture = texture;
                this.openness = openness;
            }

            @Override
            public String id() {
                return "minecraft:chest";
            }

            @Override
            public Map<String, Object> toJson() {
                HashMap<String, Object> json = new HashMap<String, Object>();
                json.put("type", this.id());
                json.put("texture", this.texture.file());
                json.put("openness", this.openness);
                return json;
            }
        }

        public static class Conduit
        implements Type {
            @Override
            public String id() {
                return "minecraft:conduit";
            }

            @Override
            public Map<String, Object> toJson() {
                return Map.of("type", this.id());
            }
        }

        public static class Bed
        implements Type {
            private final Texture texture;

            public Bed(Texture texture) {
                this.texture = texture;
            }

            @Override
            public String id() {
                return "minecraft:bed";
            }

            @Override
            public Map<String, Object> toJson() {
                HashMap<String, Object> json = new HashMap<String, Object>();
                json.put("type", this.id());
                json.put("texture", this.texture.file());
                return json;
            }
        }

        public static class Banner
        implements Type {
            private final NamedColor color;

            public Banner(NamedColor color) {
                this.color = color;
            }

            @Override
            public String id() {
                return "minecraft:banner";
            }

            @Override
            public Map<String, Object> toJson() {
                HashMap<String, Object> json = new HashMap<String, Object>();
                json.put("type", this.id());
                json.put("color", this.color.name().toLowerCase());
                return json;
            }
        }
    }

    public static class RangeDispatch
    implements Selector {
        private final Property property;
        private final List<Entry> entries = new ArrayList<Entry>();
        private int scale = 0;
        private Selector fallback = null;

        public RangeDispatch(Property property) {
            this.property = property;
        }

        public RangeDispatch(Property property, int scale) {
            this.property = property;
            this.scale = scale;
        }

        public RangeDispatch entry(int threshold, Selector selector) {
            this.entries.add(new Entry(threshold, selector));
            return this;
        }

        public RangeDispatch fallback(Selector selector) {
            this.fallback = selector;
            return this;
        }

        @Override
        public String id() {
            return "minecraft:range_dispatch";
        }

        @Override
        public Map<String, Object> toJson() {
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
            json.put("type", this.id());
            json.put("property", this.property.id());
            Property property = this.property;
            Objects.requireNonNull(property);
            Property property2 = property;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Compass.class, Time.class, UseCycle.class, UseDuration.class, CustomModelData.class, Damage.class, Count.class}, (Object)property2, n)) {
                case 0: {
                    Compass compassProperty = (Compass)property2;
                    json.put("target", compassProperty.target.type);
                    json.put("wobble", compassProperty.wobble);
                    break;
                }
                case 1: {
                    Time timeProperty = (Time)property2;
                    json.put("target", timeProperty.target.type);
                    json.put("wobble", timeProperty.wobble);
                    break;
                }
                case 2: {
                    UseCycle useCycleProperty = (UseCycle)property2;
                    json.put("period", useCycleProperty.period);
                    break;
                }
                case 3: {
                    UseDuration useDurationProperty = (UseDuration)property2;
                    json.put("remaining", useDurationProperty.remaining);
                    break;
                }
                case 4: {
                    CustomModelData customModelDataProperty = (CustomModelData)property2;
                    json.put("index", customModelDataProperty.index);
                    break;
                }
                case 5: {
                    Damage damageProperty = (Damage)property2;
                    json.put("normalize", damageProperty.normalize);
                    break;
                }
                case 6: {
                    Count countProperty = (Count)property2;
                    json.put("normalize", countProperty.normalize);
                    break;
                }
            }
            json.put("scale", this.scale);
            LinkedList entryJsons = new LinkedList();
            for (Entry entry : this.entries) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("threshold", entry.threshold);
                map.put("model", entry.selector.toJson());
                entryJsons.add(map);
            }
            json.put("entries", entryJsons);
            json.put("fallback", this.fallback.toJson());
            return json;
        }

        public static interface Property {
            public String id();
        }

        public record Entry(int threshold, Selector selector) {
        }

        public record Compass(Target target, boolean wobble) implements Property
        {
            @Override
            public String id() {
                return "minecraft:compass";
            }

            public static enum Target {
                SPAWN("spawn"),
                LODESTONE("lodestone"),
                RECOVERY("recovery");

                final String type;

                private Target(String type) {
                    this.type = type;
                }
            }
        }

        public record Time(Target target, boolean wobble) implements Property
        {
            @Override
            public String id() {
                return "minecraft:time";
            }

            public static enum Target {
                DAY_TIME("daytime"),
                MOON_PHASE("moon_phase"),
                RANDOM("random");

                final String type;

                private Target(String type) {
                    this.type = type;
                }
            }
        }

        public record UseCycle(int period) implements Property
        {
            @Override
            public String id() {
                return "minecraft:use_cycle";
            }
        }

        public record UseDuration(boolean remaining) implements Property
        {
            @Override
            public String id() {
                return "minecraft:use_duration";
            }
        }

        public record CustomModelData(int index) implements Property
        {
            @Override
            public String id() {
                return "minecraft:custom_model_data";
            }
        }

        public record Damage(boolean normalize) implements Property
        {
            @Override
            public String id() {
                return "minecraft:damage";
            }
        }

        public record Count(boolean normalize) implements Property
        {
            @Override
            public String id() {
                return "minecraft:count";
            }
        }

        public static class CrossbowPull
        implements Property {
            @Override
            public String id() {
                return "minecraft:crossbow_pull";
            }
        }

        public static class Cooldown
        implements Property {
            @Override
            public String id() {
                return "minecraft:cooldown";
            }
        }

        public static class BundleFullness
        implements Property {
            @Override
            public String id() {
                return "minecraft:bundle_fullness";
            }
        }
    }

    public static class Empty
    implements Selector {
        @Override
        public String id() {
            return "minecraft:empty";
        }

        @Override
        public Map<String, Object> toJson() {
            return Map.of("type", this.id());
        }
    }

    public static class Composite
    implements Selector {
        private final List<Selector> selectors = new ArrayList<Selector>();

        public Composite add(Selector selector) {
            this.selectors.add(selector);
            return this;
        }

        @Override
        public String id() {
            return "minecraft:composite";
        }

        @Override
        public Map<String, Object> toJson() {
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
            json.put("type", this.id());
            LinkedList<Map<String, Object>> selectorJsons = new LinkedList<Map<String, Object>>();
            for (Selector sel : this.selectors) {
                selectorJsons.add(sel.toJson());
            }
            json.put("models", selectorJsons);
            return json;
        }
    }

    public static class Condition
    implements Selector {
        private final Property property;
        private final Selector onTrue;
        private final Selector onFalse;

        public Condition(Property property, Selector onTrue, Selector onFalse) {
            this.property = property;
            this.onTrue = onTrue;
            this.onFalse = onFalse;
        }

        @Override
        public String id() {
            return "minecraft:condition";
        }

        @Override
        public Map<String, Object> toJson() {
            HashMap<String, Object> json = new HashMap<String, Object>();
            json.put("type", this.id());
            json.put("property", this.property.id());
            Property property = this.property;
            Objects.requireNonNull(property);
            Property property2 = property;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CustomModelData.class, KeybindDown.class, HasComponent.class}, (Object)property2, n)) {
                case 0: {
                    CustomModelData customModelData = (CustomModelData)property2;
                    json.put("index", customModelData.index);
                    break;
                }
                case 1: {
                    KeybindDown keybindDown = (KeybindDown)property2;
                    json.put("keybind", keybindDown.keybind.type);
                    break;
                }
                case 2: {
                    HasComponent hasComponent = (HasComponent)property2;
                    json.put("component", hasComponent.component.id());
                    json.put("ignore_default", hasComponent.ignoreDefault);
                    break;
                }
            }
            json.put("on_true", this.onTrue.toJson());
            json.put("on_false", this.onFalse.toJson());
            return json;
        }

        public static interface Property {
            public String id();
        }

        public static class CustomModelData
        implements Property {
            private final int index;

            public CustomModelData(int index) {
                this.index = index;
            }

            @Override
            public String id() {
                return "minecraft:custom_model_data";
            }
        }

        public static class KeybindDown
        implements Property {
            private final Keybind keybind;

            public KeybindDown(Keybind keybind) {
                this.keybind = keybind;
            }

            @Override
            public String id() {
                return "minecraft:keybind_down";
            }

            public static enum Keybind {
                ADVANCEMENTS("key.advancements"),
                ATTACK("key.attack"),
                BACK("key.back"),
                CHAT("key.chat"),
                COMMAND("key.command"),
                DROP("key.drop"),
                FORWARD("key.forward"),
                FULLSCREEN("key.fullscreen"),
                HOTBAR_1("key.hotbar.1"),
                HOTBAR_2("key.hotbar.2"),
                HOTBAR_3("key.hotbar.3"),
                HOTBAR_4("key.hotbar.4"),
                HOTBAR_5("key.hotbar.5"),
                HOTBAR_6("key.hotbar.6"),
                HOTBAR_7("key.hotbar.7"),
                HOTBAR_8("key.hotbar.8"),
                HOTBAR_9("key.hotbar.9"),
                INVENTORY("key.inventory"),
                JUMP("key.jump"),
                LEFT("key.left"),
                LOAD_TOOLBAR_ACTIVATOR("key.loadToolbarActivator"),
                SCREENSHOT("key.screenshot"),
                SMOOTH_CAMERA("key.smoothCamera"),
                SNEAK("key.sneak"),
                SPECTATOR_OUTLINES("key.spectatorOutlines"),
                SPRINT("key.sprint"),
                SWAP_OFFHAND("key.swapOffhand"),
                TOGGLE_PERSPECTIVE("key.togglePerspective"),
                USE("key.use");

                public final String type;

                private Keybind(String type) {
                    this.type = type;
                }
            }
        }

        public static class HasComponent
        implements Property {
            private final ContainedComponent component;
            private final boolean ignoreDefault;

            public HasComponent(ContainedComponent component, boolean ignoreDefault) {
                this.component = component;
                this.ignoreDefault = ignoreDefault;
            }

            @Override
            public String id() {
                return "minecraft:has_component";
            }
        }

        public static class ViewEntity
        implements Property {
            @Override
            public String id() {
                return "minecraft:view_entity";
            }
        }

        public static class UsingItem
        implements Property {
            @Override
            public String id() {
                return "minecraft:using_item";
            }
        }

        public static class Selected
        implements Property {
            @Override
            public String id() {
                return "minecraft:selected";
            }
        }

        public static class FishingRodCast
        implements Property {
            @Override
            public String id() {
                return "minecraft:fishing_rod/cast";
            }
        }

        public static class ExtendedView
        implements Property {
            @Override
            public String id() {
                return "minecraft:extended_view";
            }
        }

        public static class Damaged
        implements Property {
            @Override
            public String id() {
                return "minecraft:damaged";
            }
        }

        public static class Carried
        implements Property {
            @Override
            public String id() {
                return "minecraft:carried";
            }
        }

        public static class BundleHasSelectedItem
        implements Property {
            @Override
            public String id() {
                return "minecraft:bundle/has_selected_item";
            }
        }

        public static class Broken
        implements Property {
            @Override
            public String id() {
                return "minecraft:broken";
            }
        }
    }

    public static class Select
    implements Selector {
        private final Property property;
        private Selector fallback = null;

        public Select(Property property) {
            this.property = property;
        }

        public Select(Property property, Selector fallback) {
            this.property = property;
            this.fallback = fallback;
        }

        @Override
        public String id() {
            return "minecraft:select";
        }

        @Override
        public Map<String, Object> toJson() {
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
            json.put("type", this.id());
            json.put("property", this.property.id());
            Property property = this.property;
            Objects.requireNonNull(property);
            Property property2 = property;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockState.class, CustomModelData.class, LocalTime.class, Property.class}, (Object)property2, n)) {
                case 0: {
                    BlockState blockState = (BlockState)property2;
                    json.put("block_state_property", blockState.blockStateProperty);
                    ArrayList cases = new ArrayList();
                    blockState.cases.forEach(c -> cases.add(c.toJson()));
                    json.put("cases", cases);
                    break;
                }
                case 1: {
                    CustomModelData customModelData = (CustomModelData)property2;
                    if (customModelData.index != 0) {
                        json.put("index", customModelData.index);
                    }
                    ArrayList cases = new ArrayList();
                    customModelData.cases.forEach(c -> cases.add(c.toJson()));
                    json.put("cases", cases);
                    break;
                }
                case 2: {
                    LocalTime localTime = (LocalTime)property2;
                    if (localTime.pattern != null) {
                        json.put("pattern", localTime.pattern);
                    }
                    if (localTime.locale != null) {
                        json.put("locale", localTime.locale);
                    }
                    if (localTime.zoneId != null) {
                        json.put("time_zone", localTime.zoneId);
                    }
                    ArrayList cases = new ArrayList();
                    localTime.cases.forEach(c -> cases.add(c.toJson()));
                    json.put("cases", cases);
                    break;
                }
                default: {
                    Property obj = property2;
                    ArrayList cases = new ArrayList();
                    obj.getCases().forEach(c -> cases.add(c.toJson()));
                    json.put("cases", cases);
                }
            }
            if (this.fallback != null) {
                json.put("fallback", this.fallback.toJson());
            }
            return json;
        }

        public static interface Property {
            public String id();

            public List<Case> getCases();
        }

        public static class BlockState
        implements Property {
            private final List<Case> cases = new ArrayList<Case>();
            private final String blockStateProperty;

            public BlockState(List<Entry> cases, String blockStateProperty) {
                this.cases.addAll(cases);
                this.blockStateProperty = blockStateProperty;
            }

            @Override
            public String id() {
                return "minecraft:block_state";
            }

            @Override
            public List<Case> getCases() {
                return this.cases;
            }

            public static class Entry
            implements Case {
                private final List<String> when = new ArrayList<String>();
                private final Selector model;

                public Entry(String when, Selector model) {
                    this.when.add(when);
                    this.model = model;
                }

                public Entry(List<String> when, Selector model) {
                    this.when.addAll(when);
                    this.model = model;
                }

                @Override
                public Map<String, Object> toJson() {
                    LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
                    json.put("when", this.when.size() == 1 ? this.when.getFirst() : this.when);
                    json.put("model", this.model.toJson());
                    return json;
                }
            }
        }

        public static class CustomModelData
        implements Property {
            private final int index;
            private final List<Case> cases = new ArrayList<Case>();

            public CustomModelData(List<Case> cases) {
                this.index = 0;
                this.cases.addAll(cases);
            }

            public CustomModelData(int index, List<Case> cases) {
                this.index = index;
                this.cases.addAll(cases);
            }

            @Override
            public String id() {
                return "minecraft:custom_model_data";
            }

            public int getIndex() {
                return this.index;
            }

            @Override
            public List<Case> getCases() {
                return this.cases;
            }

            public static class Entry
            implements Case {
                private final List<String> cases = new ArrayList<String>();
                private final Selector model;

                public Entry(String cases, Selector model) {
                    this.cases.add(cases);
                    this.model = model;
                }

                public Entry(List<String> cases, Selector model) {
                    this.cases.addAll(cases);
                    this.model = model;
                }

                public List<String> getCases() {
                    return this.cases;
                }

                public Selector getModel() {
                    return this.model;
                }

                @Override
                public Map<String, Object> toJson() {
                    LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
                    json.put("when", this.cases.size() == 1 ? this.cases.getFirst() : this.cases);
                    json.put("model", this.model.toJson());
                    return json;
                }
            }
        }

        public static class LocalTime
        implements Property {
            private final List<Case> cases = new ArrayList<Case>();
            private String pattern = null;
            private String locale = null;
            private String zoneId = null;

            public LocalTime(List<Entry> cases) {
                this.cases.addAll(cases);
            }

            public LocalTime(List<Entry> cases, String timeFormat) {
                this.cases.addAll(cases);
                this.pattern = timeFormat;
            }

            public LocalTime(List<Entry> cases, Locale locale) {
                this.cases.addAll(cases);
                this.locale = locale.toLanguageTag();
            }

            public LocalTime(List<Entry> cases, ZoneId zoneId) {
                this.cases.addAll(cases);
                this.zoneId = zoneId.getId();
            }

            public LocalTime(List<Entry> cases, String timeFormat, Locale locale) {
                this.cases.addAll(cases);
                this.pattern = timeFormat;
                this.locale = locale.toLanguageTag();
            }

            public LocalTime(List<Entry> cases, String timeFormat, ZoneId zoneId) {
                this.cases.addAll(cases);
                this.pattern = timeFormat;
                this.zoneId = zoneId.getId();
            }

            public LocalTime(List<Entry> cases, Locale locale, ZoneId zoneId) {
                this.cases.addAll(cases);
                this.locale = locale.toLanguageTag();
                this.zoneId = zoneId.getId();
            }

            public LocalTime(List<Entry> cases, String timeFormat, Locale locale, ZoneId zoneId) {
                this.cases.addAll(cases);
                this.pattern = timeFormat;
                this.locale = locale.toLanguageTag();
                this.zoneId = zoneId.getId();
            }

            public String getPattern() {
                return this.pattern;
            }

            public String getLocale() {
                return this.locale;
            }

            public String getZoneId() {
                return this.zoneId;
            }

            @Override
            public String id() {
                return "minecraft:local_time";
            }

            @Override
            public List<Case> getCases() {
                return this.cases;
            }

            public static class Entry
            implements Case {
                private final List<String> when = new ArrayList<String>();
                private final Selector model;

                public Entry(String when, Selector model) {
                    this.when.add(when);
                    this.model = model;
                }

                public Entry(List<String> when, Selector model) {
                    this.when.addAll(when);
                    this.model = model;
                }

                @Override
                public Map<String, Object> toJson() {
                    LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
                    json.put("when", this.when.size() == 1 ? this.when.getFirst() : this.when);
                    json.put("model", this.model.toJson());
                    return json;
                }
            }
        }

        public static interface Case {
            public Map<String, Object> toJson();
        }

        public static class TrimMaterial
        implements Property {
            private final List<Case> cases = new ArrayList<Case>();

            public TrimMaterial(List<Entry> cases) {
                this.cases.addAll(cases);
            }

            @Override
            public String id() {
                return "minecraft:trim_material";
            }

            @Override
            public List<Case> getCases() {
                return this.cases;
            }

            public static class Entry
            implements Case {
                private final List<String> when = new ArrayList<String>();
                private final Selector model;

                public Entry(String when, Selector model) {
                    this.when.add(when);
                    this.model = model;
                }

                public Entry(List<String> when, Selector model) {
                    this.when.addAll(when);
                    this.model = model;
                }

                @Override
                public Map<String, Object> toJson() {
                    LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
                    json.put("when", this.when.size() == 1 ? this.when.getFirst() : this.when);
                    json.put("model", this.model.toJson());
                    return json;
                }
            }
        }

        public static class MainHand
        implements Property {
            private final List<Case> cases = new ArrayList<Case>();

            public MainHand(List<Entry> cases) {
                this.cases.addAll(cases);
            }

            @Override
            public String id() {
                return "minecraft:main_hand";
            }

            @Override
            public List<Case> getCases() {
                return this.cases;
            }

            public static enum Hand {
                LEFT,
                RIGHT;

            }

            public static class Entry
            implements Case {
                private final List<Hand> when = new ArrayList<Hand>();
                private final Selector model;

                public Entry(Hand when, Selector model) {
                    this.when.add(when);
                    this.model = model;
                }

                public Entry(List<Hand> when, Selector model) {
                    this.when.addAll(when);
                    this.model = model;
                }

                @Override
                public Map<String, Object> toJson() {
                    LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
                    json.put("when", this.when.size() == 1 ? this.when.getFirst().name().toLowerCase() : this.when.stream().map(w -> w.name().toLowerCase()));
                    json.put("model", this.model.toJson());
                    return json;
                }
            }
        }

        public static class DisplayContext
        implements Property {
            private final List<Case> cases = new ArrayList<Case>();

            public DisplayContext(List<Entry> cases) {
                this.cases.addAll(cases);
            }

            @Override
            public String id() {
                return "minecraft:display_context";
            }

            @Override
            public List<Case> getCases() {
                return this.cases;
            }

            public static enum Display {
                FIRSTPERSON_RIGHTHAND,
                FIRSTPERSON_LEFTHAND,
                THIRDPERSON_RIGHTHAND,
                THIRDPERSON_LEFTHAND,
                GUI,
                HEAD,
                GROUND,
                FIXED,
                ON_SHELF,
                NONE;

            }

            public static class Entry
            implements Case {
                private final List<Display> when = new ArrayList<Display>();
                private final Selector model;

                public Entry(Display when, Selector model) {
                    this.when.add(when);
                    this.model = model;
                }

                public Entry(List<Display> when, Selector model) {
                    this.when.addAll(when);
                    this.model = model;
                }

                @Override
                public Map<String, Object> toJson() {
                    LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
                    json.put("when", this.when.size() == 1 ? this.when.getFirst().name().toLowerCase() : this.when.stream().map(w -> w.name().toLowerCase()));
                    json.put("model", this.model.toJson());
                    return json;
                }
            }
        }

        public static class ContextEntityType
        implements Property {
            private final List<Case> cases = new ArrayList<Case>();

            public ContextEntityType(List<Entry> cases) {
                this.cases.addAll(cases);
            }

            @Override
            public String id() {
                return "minecraft:context_entity_type";
            }

            @Override
            public List<Case> getCases() {
                return this.cases;
            }

            public static class Entry
            implements Case {
                private final List<String> when = new ArrayList<String>();
                private final Selector model;

                public Entry(String when, Selector model) {
                    this.when.add(when);
                    this.model = model;
                }

                public Entry(List<String> when, Selector model) {
                    this.when.addAll(when);
                    this.model = model;
                }

                @Override
                public Map<String, Object> toJson() {
                    LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
                    json.put("when", this.when.size() == 1 ? this.when.getFirst() : this.when);
                    json.put("model", this.model.toJson());
                    return json;
                }
            }
        }

        public static class ContextDimension
        implements Property {
            private final List<Case> cases = new ArrayList<Case>();

            public ContextDimension(List<Entry> cases) {
                this.cases.addAll(cases);
            }

            @Override
            public String id() {
                return "minecraft:context_dimension";
            }

            @Override
            public List<Case> getCases() {
                return this.cases;
            }

            public static class Entry
            implements Case {
                private final List<String> when = new ArrayList<String>();
                private final Selector model;

                public Entry(String when, Selector model) {
                    this.when.add(when);
                    this.model = model;
                }

                public Entry(List<String> when, Selector model) {
                    this.when.addAll(when);
                    this.model = model;
                }

                @Override
                public Map<String, Object> toJson() {
                    LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
                    json.put("when", this.when.size() == 1 ? this.when.getFirst() : this.when);
                    json.put("model", this.model.toJson());
                    return json;
                }
            }
        }

        public static class ChargeType
        implements Property {
            private final List<Case> cases = new ArrayList<Case>();

            public ChargeType(List<Entry> when) {
                this.cases.addAll(when);
            }

            @Override
            public String id() {
                return "minecraft:charge_type";
            }

            @Override
            public List<Case> getCases() {
                return this.cases;
            }

            public static enum Type {
                NONE,
                ARROW,
                ROCKET;

            }

            public static class Entry
            implements Case {
                private final List<Type> when = new ArrayList<Type>();
                private final Selector model;

                public Entry(Type type, Selector model) {
                    this.when.add(type);
                    this.model = model;
                }

                public Entry(List<Type> types, Selector model) {
                    this.when.addAll(types);
                    this.model = model;
                }

                @Override
                public Map<String, Object> toJson() {
                    LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
                    json.put("when", this.when.size() == 1 ? this.when.getFirst() : this.when);
                    json.put("model", this.model.toJson());
                    return json;
                }
            }
        }
    }

    public static class BundleSelectedItem
    implements Selector {
        @Override
        public String id() {
            return "minecraft:bundle/selected_item";
        }

        @Override
        public Map<String, Object> toJson() {
            return Map.of("type", this.id());
        }
    }

    public static class Model
    implements Selector {
        private final com.github.darksoulq.abyssallib.server.resource.asset.Model model;
        private final List<Tint> tints = new ArrayList<Tint>();

        public Model(com.github.darksoulq.abyssallib.server.resource.asset.Model model, Tint ... tints) {
            this.model = model;
            this.tints.addAll(List.of(tints));
        }

        @Override
        public String id() {
            return "minecraft:model";
        }

        @Override
        public Map<String, Object> toJson() {
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
            json.put("type", this.id());
            json.put("model", this.model.file());
            LinkedList<Map<String, Object>> tintJsons = new LinkedList<Map<String, Object>>();
            for (Tint tint : this.tints) {
                tintJsons.add(tint.toJson());
            }
            json.put("tints", tintJsons);
            return json;
        }
    }
}

