/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.data.loot.impl;

import com.github.darksoulq.abyssallib.world.data.loot.LootContext;
import com.github.darksoulq.abyssallib.world.data.loot.LootEntry;
import com.github.darksoulq.abyssallib.world.data.loot.LootFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.bukkit.inventory.ItemStack;

public class ItemLootEntry
implements LootEntry {
    private final Supplier<ItemStack> stackSupplier;
    private final List<LootFunction> functions = new ArrayList<LootFunction>();

    public ItemLootEntry(Supplier<ItemStack> stackSupplier) {
        this.stackSupplier = stackSupplier;
    }

    public ItemLootEntry apply(LootFunction function) {
        this.functions.add(function);
        return this;
    }

    @Override
    public List<ItemStack> generate(LootContext context) {
        ItemStack stack = this.stackSupplier.get();
        for (LootFunction function : this.functions) {
            stack = function.apply(stack, context);
        }
        return List.of(stack);
    }
}

