/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.entity;

import com.github.darksoulq.abyssallib.AbyssalLib;
import com.github.darksoulq.abyssallib.common.util.CTag;
import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.github.darksoulq.abyssallib.common.util.PDCTag;
import com.github.darksoulq.abyssallib.server.event.ActionResult;
import com.github.darksoulq.abyssallib.server.event.EventBus;
import com.github.darksoulq.abyssallib.server.event.custom.entity.EntitySpawnEvent;
import com.github.darksoulq.abyssallib.server.registry.Registries;
import com.github.darksoulq.abyssallib.world.entity.SpawnCategory;
import com.github.darksoulq.abyssallib.world.entity.internal.EntityManager;
import com.github.darksoulq.abyssallib.world.entity.internal.NMSGoalHandler;
import com.github.darksoulq.abyssallib.world.item.component.ComponentMap;
import com.github.darksoulq.abyssallib.world.item.component.DataComponent;
import io.papermc.paper.datacomponent.DataComponentType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.component.CustomData;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.persistence.PersistentDataContainer;

public class Entity<T extends LivingEntity>
implements Cloneable {
    public UUID uuid = null;
    private Identifier id;
    private Class<T> baseClass;
    private SpawnCategory category;
    private final Map<Integer, Function<T, Goal>> pathfinderGoals = new LinkedHashMap<Integer, Function<T, Goal>>();
    private final Map<Integer, Function<T, Goal>> targetGoals = new LinkedHashMap<Integer, Function<T, Goal>>();
    private final Map<Attribute, Double> attributes = new LinkedHashMap<Attribute, Double>();
    private ComponentMap componentMap;
    private final Map<Attribute, List<AttributeModifier>> modifiers = new LinkedHashMap<Attribute, List<AttributeModifier>>();
    private final List<BiPredicate<World, Location>> spawnConditions = new ArrayList<BiPredicate<World, Location>>();
    private static final Map<Biome, List<SpawnEntry>> spawnTable = new HashMap<Biome, List<SpawnEntry>>();

    public Entity(Identifier id, Class<T> baseClass, SpawnCategory category) {
        this.id = id;
        this.baseClass = baseClass;
        this.category = category;
    }

    public void addGoal(int priority, Function<T, Goal> goal) {
        this.pathfinderGoals.put(priority, goal);
    }

    public void addTargetGoal(int priority, Function<T, Goal> goal) {
        this.targetGoals.put(priority, goal);
    }

    public void addSpawnCondition(BiPredicate<World, Location> cond) {
        this.spawnConditions.add(cond);
    }

    public void addSpawnWeight(Biome biome, float weight, int minGroup, int maxGroup) {
        spawnTable.computeIfAbsent(biome, k -> new ArrayList()).add(new SpawnEntry(this.id, weight, minGroup, maxGroup));
    }

    public void setAttribute(Attribute attribute, double value) {
        this.attributes.put(attribute, value);
    }

    public void addAttributeModifier(Attribute attribute, AttributeModifier modifier) {
        this.modifiers.computeIfAbsent(attribute, k -> new ArrayList()).add(modifier);
    }

    public void spawn(Location loc) {
        this.spawn(loc, EntitySpawnEvent.SpawnReason.PLUGIN);
    }

    public void spawn(Location loc, EntitySpawnEvent.SpawnReason reason) {
        if (this.uuid != null) {
            return;
        }
        LivingEntity entity = (LivingEntity)loc.getWorld().spawn(loc, this.baseClass);
        this.uuid = entity.getUniqueId();
        EntitySpawnEvent event = EventBus.post(new EntitySpawnEvent(this, reason));
        if (event.isCancelled()) {
            entity.remove();
            return;
        }
        this.onSpawn();
        this.applyGoals();
        this.applyAttributes();
        this.applyComponents();
        AbyssalLib.LOGGER.info("Entity spawned at " + String.valueOf(loc));
        EntityManager.add(this);
    }

    public void spawn(T entity) {
        this.spawn(entity, EntitySpawnEvent.SpawnReason.PLUGIN);
    }

    public void spawn(T entity, EntitySpawnEvent.SpawnReason reason) {
        if (this.uuid != null) {
            return;
        }
        this.uuid = entity.getUniqueId();
        EntitySpawnEvent event = EventBus.post(new EntitySpawnEvent(this, reason));
        if (event.isCancelled()) {
            return;
        }
        this.onSpawn();
        this.applyGoals();
        this.applyAttributes();
        this.applyComponents();
        EntityManager.add(this);
    }

    public void setData(DataComponent<?> component) {
        this.componentMap.setData(component);
    }

    public DataComponent<?> getData(Identifier id) {
        return this.componentMap.getData(id);
    }

    public DataComponent<?> getData(DataComponentType type) {
        return this.componentMap.getData(type);
    }

    public <T extends DataComponent<?>> DataComponent<?> getData(Class<T> clazz) {
        return (DataComponent)clazz.cast(this.componentMap.getData(clazz));
    }

    public boolean hasData(Identifier id) {
        return this.componentMap.hasData(id);
    }

    public boolean hasData(DataComponentType type) {
        return this.componentMap.hasData(type);
    }

    public void unsetData(Identifier id) {
        this.componentMap.removeData(id);
    }

    public void unsetData(Class<? extends DataComponent> clazz) {
        this.componentMap.removeData(clazz);
    }

    public <T extends DataComponent<?>> boolean hasData(Class<T> clazz) {
        return this.componentMap.hasData(clazz);
    }

    public void applyGoals() {
        LivingEntity entity = (LivingEntity)this.getBaseEntity().orElseThrow(() -> new IllegalStateException("Base entity is null"));
        NMSGoalHandler.clearGoals(entity);
        this.pathfinderGoals.forEach((priority, goal) -> NMSGoalHandler.addGoal(entity, (Goal)goal.apply(entity), priority));
        this.targetGoals.forEach((priority, goal) -> NMSGoalHandler.addTargetGoal(entity, (Goal)goal.apply(entity), priority));
    }

    public void applyAttributes() {
        AttributeInstance instance;
        LivingEntity entity = (LivingEntity)this.getBaseEntity().orElseThrow(() -> new IllegalStateException("Base entity is null"));
        for (Map.Entry<Attribute, Double> entry : this.attributes.entrySet()) {
            instance = entity.getAttribute(entry.getKey());
            if (instance == null) continue;
            instance.setBaseValue(entry.getValue().doubleValue());
        }
        for (Map.Entry<Attribute, Object> entry : this.modifiers.entrySet()) {
            instance = entity.getAttribute(entry.getKey());
            if (instance == null) continue;
            for (AttributeModifier modifier : (List)entry.getValue()) {
                instance.addModifier(modifier);
            }
        }
    }

    public void applyComponents() {
        this.componentMap = new ComponentMap(this);
    }

    public Identifier getId() {
        return this.id;
    }

    public Optional<PDCTag> getData() {
        if (this.uuid == null) {
            return Optional.empty();
        }
        LivingEntity entity = (LivingEntity)Bukkit.getEntity((UUID)this.uuid);
        if (entity == null) {
            return Optional.empty();
        }
        PersistentDataContainer container = entity.getPersistentDataContainer();
        return Optional.of(new PDCTag(container));
    }

    public CTag getCTag() {
        CompoundTag tag;
        if (this.uuid == null) {
            return null;
        }
        if (this.getBaseEntity().isEmpty()) {
            return null;
        }
        LivingEntity entity = (LivingEntity)this.getBaseEntity().get();
        CustomData dta = (CustomData)((CraftLivingEntity)entity).getHandle().get(DataComponents.CUSTOM_DATA);
        if (dta == null) {
            dta = CustomData.EMPTY;
        }
        if ((tag = dta.copyTag()).getCompound("CustomData").isPresent()) {
            CompoundTag custom = (CompoundTag)tag.getCompound("CustomData").get();
            return new CTag(custom);
        }
        tag.put("CustomData", (Tag)new CompoundTag());
        return new CTag((CompoundTag)tag.getCompound("CustomData").get());
    }

    public void setCTag(CTag container) {
        if (this.uuid == null) {
            return;
        }
        if (this.getBaseEntity().isEmpty()) {
            return;
        }
        LivingEntity entity = (LivingEntity)this.getBaseEntity().get();
        CustomData data = (CustomData)((CraftLivingEntity)entity).getHandle().get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            data = CustomData.EMPTY;
        }
        CompoundTag tag = data.copyTag();
        tag.put("CustomData", (Tag)container.toVanilla());
        data = CustomData.of((CompoundTag)tag);
        ((CraftLivingEntity)entity).getHandle().setComponent(DataComponents.CUSTOM_DATA, (Object)data);
    }

    public Optional<T> getBaseEntity() {
        return Optional.ofNullable((LivingEntity)Bukkit.getEntity((UUID)this.uuid));
    }

    public SpawnCategory getCategory() {
        return this.category;
    }

    public List<BiPredicate<World, Location>> getSpawnConditions() {
        return this.spawnConditions;
    }

    public void onSpawn() {
    }

    public ActionResult onDeath(EntityDeathEvent event) {
        return ActionResult.PASS;
    }

    public void onUnload() {
    }

    public void onLoad() {
    }

    public static Entity<? extends LivingEntity> resolve(org.bukkit.entity.Entity entity) {
        return EntityManager.get(entity.getUniqueId());
    }

    public static EntityEntry getWeighedSpawnEntry(Biome biome, SpawnCategory category) {
        HashMap entities = new HashMap();
        List<SpawnEntry> entries = spawnTable.get(biome);
        if (entries == null) {
            return null;
        }
        entries.forEach(se -> {
            Entity<? extends LivingEntity> entity = Registries.ENTITIES.get(se.id.toString());
            if (entity == null) {
                return;
            }
            if (!entity.category.equals((Object)category)) {
                return;
            }
            entities.put(se, entity);
        });
        if (entities.isEmpty()) {
            return null;
        }
        double totalWeight = entities.keySet().stream().mapToDouble(e -> e.weight).sum();
        double r = EntityManager.rand.nextDouble(totalWeight);
        double running = 0.0;
        for (SpawnEntry entry : entities.keySet()) {
            if (!(r < (running += (double)entry.weight))) continue;
            return new EntityEntry(entry, (Entity)entities.get(entry));
        }
        return null;
    }

    public Entity<T> clone() {
        try {
            Entity copy = (Entity)super.clone();
            copy.id = this.id;
            copy.baseClass = this.baseClass;
            copy.category = this.category;
            this.pathfinderGoals.forEach(copy::addGoal);
            this.targetGoals.forEach(copy::addTargetGoal);
            this.attributes.forEach(copy::setAttribute);
            copy.spawnConditions.addAll(this.spawnConditions);
            this.modifiers.forEach((attr, list) -> list.forEach(mod -> copy.addAttributeModifier((Attribute)attr, (AttributeModifier)mod)));
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public record SpawnEntry(Identifier id, float weight, int minGroup, int maxGroup) {
    }

    public record EntityEntry(SpawnEntry entry, Entity<? extends LivingEntity> entity) {
    }
}

