/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.entity.data;

import com.github.darksoulq.abyssallib.world.entity.data.AttributeOperation;
import java.math.BigDecimal;

public class AttributeModifier<T extends Number> {
    private final T value;
    private final AttributeOperation operation;

    public AttributeModifier(T value, AttributeOperation operation) {
        this.value = value;
        this.operation = operation;
    }

    public T getValue() {
        return this.value;
    }

    public AttributeOperation getOperation() {
        return this.operation;
    }

    public int applyToInt(int base) {
        int mod = ((Number)this.value).intValue();
        return switch (this.operation) {
            default -> throw new MatchException(null, null);
            case AttributeOperation.ADD -> base + mod;
            case AttributeOperation.SUBTRACT -> base - mod;
            case AttributeOperation.MULTIPLY -> base * mod;
            case AttributeOperation.DIVIDE -> mod == 0 ? base : base / mod;
        };
    }

    public float applyToFloat(float base) {
        float mod = ((Number)this.value).floatValue();
        return switch (this.operation) {
            default -> throw new MatchException(null, null);
            case AttributeOperation.ADD -> base + mod;
            case AttributeOperation.SUBTRACT -> base - mod;
            case AttributeOperation.MULTIPLY -> base * mod;
            case AttributeOperation.DIVIDE -> mod == 0.0f ? base : base / mod;
        };
    }

    public double applyToDouble(double base) {
        double mod = ((Number)this.value).doubleValue();
        return switch (this.operation) {
            default -> throw new MatchException(null, null);
            case AttributeOperation.ADD -> base + mod;
            case AttributeOperation.SUBTRACT -> base - mod;
            case AttributeOperation.MULTIPLY -> base * mod;
            case AttributeOperation.DIVIDE -> mod == 0.0 ? base : base / mod;
        };
    }

    public long applyToLong(long base) {
        long mod = ((Number)this.value).longValue();
        return switch (this.operation) {
            default -> throw new MatchException(null, null);
            case AttributeOperation.ADD -> base + mod;
            case AttributeOperation.SUBTRACT -> base - mod;
            case AttributeOperation.MULTIPLY -> base * mod;
            case AttributeOperation.DIVIDE -> mod == 0L ? base : base / mod;
        };
    }

    public short applyToShort(short base) {
        short mod = ((Number)this.value).shortValue();
        return switch (this.operation) {
            default -> throw new MatchException(null, null);
            case AttributeOperation.ADD -> (short)(base + mod);
            case AttributeOperation.SUBTRACT -> (short)(base - mod);
            case AttributeOperation.MULTIPLY -> (short)(base * mod);
            case AttributeOperation.DIVIDE -> mod == 0 ? base : (short)(base / mod);
        };
    }

    public byte applyToByte(byte base) {
        byte mod = ((Number)this.value).byteValue();
        return switch (this.operation) {
            default -> throw new MatchException(null, null);
            case AttributeOperation.ADD -> (byte)(base + mod);
            case AttributeOperation.SUBTRACT -> (byte)(base - mod);
            case AttributeOperation.MULTIPLY -> (byte)(base * mod);
            case AttributeOperation.DIVIDE -> mod == 0 ? base : (byte)(base / mod);
        };
    }

    public BigDecimal applyToBigDecimal(BigDecimal base) {
        BigDecimal b;
        T t = this.value;
        BigDecimal mod = t instanceof BigDecimal ? (b = (BigDecimal)t) : new BigDecimal(this.value.toString());
        return switch (this.operation) {
            default -> throw new MatchException(null, null);
            case AttributeOperation.ADD -> base.add(mod);
            case AttributeOperation.SUBTRACT -> base.subtract(mod);
            case AttributeOperation.MULTIPLY -> base.multiply(mod);
            case AttributeOperation.DIVIDE -> mod.compareTo(BigDecimal.ZERO) == 0 ? base : base.divide(mod, 4);
        };
    }
}

