/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.gui;

import com.github.darksoulq.abyssallib.world.gui.Gui;
import com.github.darksoulq.abyssallib.world.gui.GuiView;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GuiManager {
    public static final Map<InventoryView, GuiView> openViews = new HashMap<InventoryView, GuiView>();

    public static void open(HumanEntity player, Gui gui) {
        if (player.isSleeping() || player.getPortalCooldown() > 0) {
            return;
        }
        InventoryView view = gui.getMenuType().create(player, gui.getTitle());
        view.open();
        GuiView guiView = new GuiView(gui, view);
        gui.getOnOpen().accept(guiView);
        openViews.put(view, guiView);
    }

    public static void close(HumanEntity player) {
        InventoryView view = player.getOpenInventory();
        GuiView guiView = openViews.remove(view);
        if (guiView != null) {
            guiView.close(player);
        }
        view.close();
    }

    public static void init(Plugin pl) {
        new BukkitRunnable(){

            public void run() {
                openViews.values().forEach(GuiView::tick);
            }
        }.runTaskTimer(pl, 0L, 1L);
    }
}

