/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.gui.impl;

import com.github.darksoulq.abyssallib.world.gui.GuiLayer;
import com.github.darksoulq.abyssallib.world.gui.GuiView;
import java.util.ArrayList;
import java.util.List;

public class ListedLayers
implements GuiLayer {
    private final List<GuiLayer> layers = new ArrayList<GuiLayer>();
    private int index = 0;
    private int lastRenderedPage = -1;

    public ListedLayers(List<GuiLayer> layers) {
        this.layers.addAll(layers);
    }

    public void next(GuiView view) {
        if (this.layers.isEmpty()) {
            return;
        }
        GuiLayer layer = this.layers.get(this.index);
        this.index = (this.index + 1) % this.layers.size();
        layer.cleanup(view);
    }

    public void prev(GuiView view) {
        if (this.layers.isEmpty()) {
            return;
        }
        GuiLayer layer = this.layers.get(this.index);
        this.index = (this.index - 1 + this.layers.size()) % this.layers.size();
        layer.cleanup(view);
    }

    @Override
    public void renderTo(GuiView view) {
        if (this.index == this.lastRenderedPage) {
            return;
        }
        GuiLayer layer = this.layers.get(this.index);
        if (layer == null) {
            return;
        }
        layer.renderTo(view);
        this.lastRenderedPage = this.index;
    }

    @Override
    public void cleanup(GuiView view) {
        if (!this.layers.isEmpty()) {
            this.layers.get(this.index).cleanup(view);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public int getSize() {
        return this.layers.size();
    }

    public void resetPage() {
        this.lastRenderedPage = -1;
    }
}

