/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    private final File file;
    private final YamlConfiguration yaml;
    private final Map<String, List<String>> comments = new HashMap<String, List<String>>();

    public Config(String pluginId, String name, String subfolder) {
        this.file = Path.of("config", pluginId, subfolder, name + ".yml").toFile();
        this.yaml = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public Config(String pluginId, String name) {
        this.file = Path.of("config", pluginId, name + ".yml").toFile();
        this.yaml = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public <T> Value<T> value(String path, T defaultValue) {
        Value<T> val = new Value<T>(path, defaultValue);
        if (!this.yaml.contains(path)) {
            val.set(defaultValue);
        }
        return val;
    }

    public void addComment(String path, String ... commentLines) {
        this.comments.put(path, Arrays.asList(commentLines));
    }

    public void save() {
        try {
            this.yaml.save(this.file);
            this.writeComments();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save configuration file: " + String.valueOf(this.file), e);
        }
    }

    public void reload() {
        this.yaml.options().copyDefaults(true);
        try {
            this.yaml.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new RuntimeException("Failed to reload configuration file: " + String.valueOf(this.file), e);
        }
    }

    private void writeComments() throws IOException {
        List<String> lines = Files.readAllLines(this.file.toPath());
        ArrayList<Object> newLines = new ArrayList<Object>();
        ArrayDeque<String> pathStack = new ArrayDeque<String>();
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            String trimmed = line.trim();
            if (trimmed.startsWith("#") || !trimmed.contains(":")) {
                newLines.add(line);
                continue;
            }
            int indent = this.countLeadingSpaces(line) / 2;
            while (pathStack.size() > indent) {
                pathStack.removeLast();
            }
            String key = trimmed.split(":", 2)[0];
            pathStack.addLast(key);
            String fullPath = String.join((CharSequence)".", pathStack);
            if (this.comments.containsKey(fullPath)) {
                List<String> commentLines = this.comments.get(fullPath);
                boolean alreadyPresent = true;
                for (int j = 0; j < commentLines.size(); ++j) {
                    int checkLineIndex = newLines.size() - commentLines.size() + j;
                    if (checkLineIndex >= 0 && ((String)newLines.get(checkLineIndex)).trim().equals("# " + commentLines.get(j))) continue;
                    alreadyPresent = false;
                    break;
                }
                if (!alreadyPresent) {
                    for (String commentLine : commentLines) {
                        newLines.add("  ".repeat(indent) + "# " + commentLine);
                    }
                }
            }
            newLines.add(line);
        }
        Files.write(this.file.toPath(), newLines, new OpenOption[0]);
    }

    private int countLeadingSpaces(String line) {
        int count;
        for (count = 0; count < line.length() && line.charAt(count) == ' '; ++count) {
        }
        return count;
    }

    public class Value<T> {
        private final String path;
        private final T defaultValue;

        public Value(String path, T defaultValue) {
            this.path = path;
            this.defaultValue = defaultValue;
        }

        public T get() {
            return (T)this.readRaw(Config.this.yaml.get(this.path, this.defaultValue));
        }

        public void set(T value) {
            Config.this.yaml.set(this.path, value);
        }

        public Value<T> withComment(String ... comments) {
            Config.this.addComment(this.path, comments);
            return this;
        }

        private Object readRaw(Object obj) {
            if (obj instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)obj;
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                for (String key : section.getKeys(false)) {
                    map.put(key, this.readRaw(section.get(key)));
                }
                return map;
            }
            if (obj instanceof List) {
                List list = (List)obj;
                ArrayList<Object> newList = new ArrayList<Object>();
                for (Object item : list) {
                    newList.add(this.readRaw(item));
                }
                return newList;
            }
            return obj;
        }
    }
}

