/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.config.internal;

import com.github.darksoulq.abyssallib.common.config.Config;

public class PluginConfig {
    public Config cfg = new Config("abyssallib", "config");
    public Config.Value<Boolean> metrics = this.cfg.value("metrics", true).withComment("Whether to enable BStats or not");
    public ResourcePack rp = new ResourcePack(this.cfg);
    public SpawnLimits spawnLimits = new SpawnLimits(this.cfg);

    public static class ResourcePack {
        public Config.Value<Boolean> enabled;
        public Config.Value<String> ip;
        public Config.Value<Integer> port;

        public ResourcePack(Config cfg) {
            this.enabled = cfg.value("resource-pack.enabled", false).withComment("Whether autohosting is enabled; in case set to false and ResourcePackManager is installed, RSPM will be used.");
            this.ip = cfg.value("resource-pack.ip", "127.0.0.1");
            this.port = cfg.value("resource-pack.port", 8080);
        }
    }

    public static class SpawnLimits {
        public Config.Value<Integer> monster;
        public Config.Value<Integer> creature;
        public Config.Value<Integer> ambient;
        public Config.Value<Integer> waterMonster;
        public Config.Value<Integer> waterCreature;
        public Config.Value<Integer> waterAmbient;

        public SpawnLimits(Config cfg) {
            this.monster = cfg.value("spawn_limits.monster", 70);
            this.creature = cfg.value("spawn_limits.creature", 10);
            this.ambient = cfg.value("spawn_limits.ambient", 5);
            this.waterMonster = cfg.value("spawn_limits.water_monster", 15);
            this.waterCreature = cfg.value("spawn_limits.water_creature", 10);
            this.waterAmbient = cfg.value("spawn_limits.water_ambient", 5);
        }
    }
}

