/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.config.legacy;

import com.github.darksoulq.abyssallib.common.config.legacy.ConfigParser;
import com.github.darksoulq.abyssallib.common.util.TextUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConfigSpec {
    private final Map<String, Definition> definitions = new HashMap<String, Definition>();
    private final Map<String, Object> values = new ConcurrentHashMap<String, Object>();

    public ConfigSpec() {
    }

    public ConfigSpec(InputStream defaultsFile) {
        this.loadDefaults(defaultsFile);
    }

    private void loadDefaults(InputStream inputStream) {
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            JsonElement json = (JsonElement)TextUtil.GSON.fromJson((Reader)reader, JsonElement.class);
            if (json != null && json.isJsonObject()) {
                this.parseDefaults(json.getAsJsonObject(), "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseDefaults(JsonObject object, String path) {
        for (Map.Entry entry : object.entrySet()) {
            String fullPath = path.isEmpty() ? (String)entry.getKey() : path + "." + (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (value.isJsonObject()) {
                this.parseDefaults(value.getAsJsonObject(), fullPath);
                continue;
            }
            Object parsed = ConfigParser.parseValue(value);
            ConfigType type = this.inferConfigType(parsed);
            this.define(type, fullPath, parsed);
        }
    }

    private ConfigType inferConfigType(Object value) {
        if (value instanceof Integer) {
            return ConfigType.INT;
        }
        if (value instanceof Float || value instanceof Double) {
            return ConfigType.FLOAT;
        }
        if (value instanceof Boolean) {
            return ConfigType.BOOLEAN;
        }
        if (value instanceof String) {
            return ConfigType.STRING;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.isEmpty()) {
                return ConfigType.LIST_STRING;
            }
            Object first = list.getFirst();
            if (first instanceof Integer) {
                return ConfigType.LIST_INT;
            }
            if (first instanceof Float || first instanceof Double) {
                return ConfigType.LIST_FLOAT;
            }
            if (first instanceof Boolean) {
                return ConfigType.LIST_BOOLEAN;
            }
            return ConfigType.LIST_STRING;
        }
        return ConfigType.STRING;
    }

    public <T> void define(ConfigType type, String path, T defaultValue) {
        this.define(type, path, defaultValue, null, null);
    }

    public <T> void define(ConfigType type, String path, T defaultValue, Number min, Number max) {
        Range range = min != null && max != null && (type == ConfigType.INT || type == ConfigType.FLOAT) ? new Range(min, max) : null;
        Object safeDefault = this.coerceValue(type, defaultValue, range);
        this.definitions.put(path, new Definition(type, safeDefault, range));
        this.values.putIfAbsent(path, safeDefault);
    }

    public <T> T get(ConfigType type, String path) {
        Object val = this.values.get(path);
        Definition def = this.definitions.get(path);
        if (def == null || val == null || def.type != type) {
            return null;
        }
        return (T)val;
    }

    public void set(ConfigType type, String path, Object value) {
        Definition def = this.definitions.get(path);
        if (def == null || def.type != type) {
            return;
        }
        Object coerced = this.coerceValue(type, value, def.range);
        if (coerced != null) {
            this.values.put(path, coerced);
        }
    }

    public Object get(String path) {
        return this.values.get(path);
    }

    public Map<String, Object> getAllValues() {
        return this.values;
    }

    public Map<String, Object> getAllDefaults() {
        HashMap<String, Object> out = new HashMap<String, Object>();
        for (Map.Entry<String, Definition> entry : this.definitions.entrySet()) {
            out.put(entry.getKey(), entry.getValue().defaultValue);
        }
        return out;
    }

    public ConfigType getDefinitionType(String path) {
        Definition def = this.definitions.get(path);
        return def != null ? def.type : null;
    }

    public Range getRange(String path) {
        Definition def = this.definitions.get(path);
        return def != null ? def.range : null;
    }

    private Object coerceValue(ConfigType type, Object value, Range range) {
        try {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    int i;
                    int v0 = i = value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(value.toString());
                    if (range != null && (i < range.min.intValue() || i > range.max.intValue())) {
                        yield range.min.intValue();
                    }
                    yield i;
                }
                case 1 -> {
                    float f;
                    float v2 = f = value instanceof Number ? ((Number)value).floatValue() : Float.parseFloat(value.toString());
                    if (range != null && (f < range.min.floatValue() || f > range.max.floatValue())) {
                        yield Float.valueOf(range.min.floatValue());
                    }
                    yield Float.valueOf(f);
                }
                case 2 -> {
                    if (value instanceof Boolean) {
                        yield value;
                    }
                    yield Boolean.parseBoolean(value.toString());
                }
                case 3 -> value.toString();
                case 4 -> ((List)value).stream().map(o -> Integer.parseInt(o.toString())).toList();
                case 5 -> ((List)value).stream().map(o -> Float.valueOf(Float.parseFloat(o.toString()))).toList();
                case 6 -> ((List)value).stream().map(o -> Boolean.parseBoolean(o.toString())).toList();
                case 7 -> ((List)value).stream().map(Object::toString).toList();
            };
        }
        catch (Exception e) {
            return null;
        }
    }

    public Integer getInt(String path) {
        return (Integer)this.get(ConfigType.INT, path);
    }

    public Float getFloat(String path) {
        return (Float)this.get(ConfigType.FLOAT, path);
    }

    public Boolean getBoolean(String path) {
        return (Boolean)this.get(ConfigType.BOOLEAN, path);
    }

    public String getString(String path) {
        return (String)this.get(ConfigType.STRING, path);
    }

    public List<Integer> getListInt(String path) {
        return (List)this.get(ConfigType.LIST_INT, path);
    }

    public List<Float> getListFloat(String path) {
        return (List)this.get(ConfigType.LIST_FLOAT, path);
    }

    public List<Boolean> getListBoolean(String path) {
        return (List)this.get(ConfigType.LIST_BOOLEAN, path);
    }

    public List<String> getListString(String path) {
        return (List)this.get(ConfigType.LIST_STRING, path);
    }

    public String toString() {
        return this.values.toString();
    }

    public static enum ConfigType {
        INT,
        FLOAT,
        BOOLEAN,
        STRING,
        LIST_INT,
        LIST_FLOAT,
        LIST_BOOLEAN,
        LIST_STRING;

    }

    public record Range(Number min, Number max) {
    }

    private record Definition(ConfigType type, Object defaultValue, Range range) {
    }
}

