/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.energy;

import com.github.darksoulq.abyssallib.common.energy.EnergyNetwork;
import com.github.darksoulq.abyssallib.common.energy.EnergyNode;
import com.github.darksoulq.abyssallib.server.event.EventBus;
import com.github.darksoulq.abyssallib.server.event.custom.energy.EnergyNodeChangeEvent;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.bukkit.Bukkit;

public abstract class AbstractEnergyNode
implements EnergyNode {
    private final Set<EnergyNode> connections = new CopyOnWriteArraySet<EnergyNode>();
    private double energy;
    private double capacity;

    public AbstractEnergyNode(double capacity, double initial) {
        this.capacity = Math.max(0.0, capacity);
        this.energy = Math.max(0.0, Math.min(initial, capacity));
        EnergyNetwork.register(this);
    }

    @Override
    public Set<EnergyNode> getConnections() {
        return this.connections;
    }

    @Override
    public double insert(double amount) {
        if (amount <= 0.0 || this.capacity <= 0.0) {
            return 0.0;
        }
        double old = this.energy;
        double toInsert = Math.min(amount, this.capacity - this.energy);
        if (toInsert <= 0.0) {
            return 0.0;
        }
        this.energy += toInsert;
        if (toInsert > 0.0) {
            EventBus.post(new EnergyNodeChangeEvent(this, old, this.energy, !Bukkit.isPrimaryThread()));
        }
        return toInsert;
    }

    @Override
    public double extract(double amount) {
        if (amount <= 0.0 || this.energy <= 0.0) {
            return 0.0;
        }
        double old = this.energy;
        double toExtract = Math.min(amount, this.energy);
        this.energy -= toExtract;
        if (toExtract > 0.0) {
            EventBus.post(new EnergyNodeChangeEvent(this, old, this.energy, !Bukkit.isPrimaryThread()));
        }
        return toExtract;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public double getCapacity() {
        return this.capacity;
    }

    public void setCapacity(double cap) {
        double old = this.capacity;
        this.capacity = Math.max(0.0, cap);
        if (this.energy > this.capacity) {
            double prev = this.energy;
            this.energy = this.capacity;
            EventBus.post(new EnergyNodeChangeEvent(this, prev, this.energy, !Bukkit.isPrimaryThread()));
        }
        if (old != this.capacity) {
            EventBus.post(new EnergyNodeChangeEvent(this, old, this.capacity, !Bukkit.isPrimaryThread()));
        }
    }
}

