/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.energy;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.darksoulq.abyssallib.AbyssalLib;
import com.github.darksoulq.abyssallib.common.database.Database;
import com.github.darksoulq.abyssallib.common.database.impl.sqlite.SqliteDatabase;
import com.github.darksoulq.abyssallib.common.energy.EnergyNode;
import com.github.darksoulq.abyssallib.common.serialization.ops.JsonOps;
import com.github.darksoulq.abyssallib.server.event.EventBus;
import com.github.darksoulq.abyssallib.server.event.custom.energy.EnergyNetworkTransferEvent;
import com.github.darksoulq.abyssallib.server.event.custom.energy.EnergyNodeAddEvent;
import com.github.darksoulq.abyssallib.server.event.custom.energy.EnergyNodeRemoveEvent;
import java.io.File;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class EnergyNetwork {
    public static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final Set<EnergyNode> NODES = new CopyOnWriteArraySet<EnergyNode>();
    private static final Set<EnergyNode> ACTIVE_NODES = new CopyOnWriteArraySet<EnergyNode>();
    private static final Database database = new SqliteDatabase(new File(AbyssalLib.getInstance().getDataFolder(), "energy_network.db"));

    private EnergyNetwork() {
    }

    public static void init() {
        new BukkitRunnable(){

            public void run() {
                EnergyNetwork.distribute();
            }
        }.runTaskTimer((Plugin)AbyssalLib.getInstance(), 0L, 1L);
        new BukkitRunnable(){

            public void run() {
                EnergyNetwork.save();
            }
        }.runTaskTimer((Plugin)AbyssalLib.getInstance(), 2400L, 6000L);
        try {
            database.connect();
            database.executor().table("energy_nodes").create().ifNotExists().column("id", "TEXT").column("json", "TEXT").primaryKey("id").execute();
        }
        catch (Exception e) {
            AbyssalLib.getInstance().getLogger().severe("Failed to init energy network DB: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void register(EnergyNode node) {
        EnergyNodeAddEvent event = new EnergyNodeAddEvent(node, !Bukkit.isPrimaryThread());
        EventBus.post(event);
        if (event.isCancelled()) {
            return;
        }
        NODES.add(node);
        if (node.canProvide() || node.canReceive()) {
            ACTIVE_NODES.add(node);
        }
    }

    public static void unregister(EnergyNode node) {
        EnergyNodeRemoveEvent event = new EnergyNodeRemoveEvent(node, !Bukkit.isPrimaryThread());
        EventBus.post(event);
        if (event.isCancelled()) {
            return;
        }
        NODES.remove(node);
        ACTIVE_NODES.remove(node);
        node.getConnections().forEach(n -> n.disconnect(node));
    }

    public static Set<EnergyNode> getNodes() {
        return NODES;
    }

    public static void markActive(EnergyNode node) {
        if (node.canProvide() || node.canReceive()) {
            ACTIVE_NODES.add(node);
        } else {
            ACTIVE_NODES.remove(node);
        }
    }

    public static void distribute() {
        if (ACTIVE_NODES.isEmpty()) {
            return;
        }
        CopyOnWriteArraySet<EnergyNode> processed = new CopyOnWriteArraySet<EnergyNode>(ACTIVE_NODES);
        for (EnergyNode source : processed) {
            if (source.getEnergy() <= 0.0) {
                ACTIVE_NODES.remove(source);
                continue;
            }
            double available = source.getEnergy();
            for (EnergyNode target : source.getConnections()) {
                double inserted;
                double space;
                double toTransfer;
                if (target.getEnergy() >= target.getCapacity() || (toTransfer = Math.min(available, space = target.getCapacity() - target.getEnergy())) <= 0.0) continue;
                EnergyNetworkTransferEvent event = new EnergyNetworkTransferEvent(source, target, toTransfer, !Bukkit.isPrimaryThread());
                EventBus.post(event);
                if (event.isCancelled() || (toTransfer = event.getAmount()) <= 0.0) continue;
                double extracted = source.extract(toTransfer);
                if (extracted > (inserted = target.insert(extracted))) {
                    source.insert(extracted - inserted);
                }
                EnergyNetwork.markActive(target);
                if (!((available -= inserted) <= 0.0)) continue;
                break;
            }
            EnergyNetwork.markActive(source);
        }
    }

    public static void save() {
        try {
            for (EnergyNode node : NODES) {
                String id = node.getClass().getName() + "@" + node.hashCode();
                JsonNode json = node.serialize(JsonOps.INSTANCE);
                database.executor().table("energy_nodes").insert().value("id", id).value("json", json.toString()).execute();
            }
        }
        catch (Exception e) {
            AbyssalLib.getInstance().getLogger().severe("Failed to save energy network: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void load() {
        try {
            database.executor().table("energy_nodes").select(rs -> {
                String jsonStr = rs.getString("json");
                JsonNode nodeJson = JSON_MAPPER.readTree(jsonStr);
                EnergyNode node = EnergyNode.deserialize(JsonOps.INSTANCE, nodeJson);
                EnergyNetwork.register(node);
                return null;
            });
        }
        catch (Exception e) {
            AbyssalLib.getInstance().getLogger().severe("Failed to load energy network: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

