/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.energy;

import com.github.darksoulq.abyssallib.common.serialization.Codec;
import com.github.darksoulq.abyssallib.common.serialization.DynamicOps;
import java.util.Set;

public interface EnergyNode {
    public double getEnergy();

    public double getCapacity();

    public double insert(double var1);

    public double extract(double var1);

    public Set<EnergyNode> getConnections();

    default public void connect(EnergyNode other) {
        this.getConnections().add(other);
        other.getConnections().add(this);
    }

    default public void disconnect(EnergyNode other) {
        this.getConnections().remove(other);
        other.getConnections().remove(this);
    }

    default public boolean canReceive() {
        return this.getEnergy() < this.getCapacity();
    }

    default public boolean canProvide() {
        return this.getEnergy() > 0.0;
    }

    public Codec<? extends EnergyNode> getCodec();

    default public <T> T serialize(DynamicOps<T> ops) {
        try {
            return this.getCodec().encode(ops, this);
        }
        catch (Codec.CodecException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> EnergyNode deserialize(DynamicOps<T> ops, T input) {
        try {
            T classValue = ops.getMap(input).orElseThrow(() -> new RuntimeException("Input is not a map")).get(ops.createString("class"));
            String className = ops.getStringValue(classValue).orElseThrow(() -> new RuntimeException("Missing class field"));
            Class<?> clazz = Class.forName(className);
            Codec codec = (Codec)clazz.getField("CODEC").get(null);
            return (EnergyNode)codec.decode(ops, input);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

