/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class FileUtils {
    public static void saveFile(InputStream inputStream, File file) throws IOException {
        int length;
        FileOutputStream outputStream = new FileOutputStream(file);
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) > 0) {
            ((OutputStream)outputStream).write(buffer, 0, length);
        }
    }

    public static void deleteFolder(Path folder) throws IOException {
        if (!Files.exists(folder, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            @NotNull
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void createDirectories(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            System.err.println("Failed to create directory: " + dir.getPath());
        }
    }

    public static void addFileToZip(File file, String basePath, ZipOutputStream zos) throws IOException {
        block8: {
            block7: {
                if (!file.isDirectory()) break block7;
                File[] children = file.listFiles();
                if (children == null) break block8;
                for (File subFile : children) {
                    FileUtils.addFileToZip(subFile, basePath, zos);
                }
                break block8;
            }
            try (FileInputStream fis = new FileInputStream(file);){
                int length;
                String relativePath = file.getAbsolutePath().substring(basePath.length() + 1);
                zos.putNextEntry(new ZipEntry(relativePath.replace("\\", "/")));
                byte[] buffer = new byte[1024];
                while ((length = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, length);
                }
                zos.closeEntry();
            }
        }
    }

    public static List<String> getFilePathList(Plugin plugin, String basePath) {
        ArrayList<String> files = new ArrayList<String>();
        String resourcePath = basePath.isEmpty() ? "" : (basePath.endsWith("/") ? basePath : basePath + "/");
        try {
            URL jarUrl = plugin.getClass().getProtectionDomain().getCodeSource().getLocation();
            if (jarUrl == null) {
                return files;
            }
            File jarFile = new File(jarUrl.toURI());
            try (JarFile jar = new JarFile(jarFile);){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    String entryName = entries.nextElement().getName();
                    if (!entryName.startsWith(resourcePath) || entryName.endsWith("/")) continue;
                    files.add(entryName);
                }
            }
        }
        catch (Exception e) {
            plugin.getLogger().warning("Failed to read plugin resources: " + e.getMessage());
        }
        return files;
    }

    public static void zipFolder(File folder, File zipFile) {
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));){
            String basePath = folder.getAbsolutePath();
            FileUtils.addFileToZip(folder, basePath, zos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String sha1(Path path) {
        String string;
        FileInputStream fis = new FileInputStream(path.toFile());
        try {
            int read;
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] buffer = new byte[8192];
            while ((read = fis.read(buffer)) != -1) {
                digest.update(buffer, 0, read);
            }
            byte[] hashBytes = digest.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : hashBytes) {
                sb.append(String.format("%02x", b));
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new RuntimeException("Failed to compute hash for " + String.valueOf(path), e);
            }
        }
        fis.close();
        return string;
    }
}

