/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.util;

import com.github.darksoulq.abyssallib.common.util.Identifier;
import java.util.Optional;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class PDCTag {
    private final PersistentDataContainer container;

    public PDCTag(PersistentDataContainer container) {
        this.container = container;
    }

    public void set(Identifier key, String value) {
        this.container.set(key.asNamespacedKey(), PersistentDataType.STRING, (Object)value);
    }

    public void set(Identifier key, int value) {
        this.container.set(key.asNamespacedKey(), PersistentDataType.INTEGER, (Object)value);
    }

    public void set(Identifier key, int[] value) {
        this.container.set(key.asNamespacedKey(), PersistentDataType.INTEGER_ARRAY, (Object)value);
    }

    public void set(Identifier key, boolean value) {
        this.container.set(key.asNamespacedKey(), PersistentDataType.BOOLEAN, (Object)value);
    }

    public void set(Identifier key, float value) {
        this.container.set(key.asNamespacedKey(), PersistentDataType.FLOAT, (Object)Float.valueOf(value));
    }

    public void set(Identifier key, byte value) {
        this.container.set(key.asNamespacedKey(), PersistentDataType.BYTE, (Object)value);
    }

    public void set(Identifier key, byte[] value) {
        this.container.set(key.asNamespacedKey(), PersistentDataType.BYTE_ARRAY, (Object)value);
    }

    public Optional<String> getString(Identifier key) {
        return Optional.ofNullable((String)this.container.get(key.asNamespacedKey(), PersistentDataType.STRING));
    }

    public Optional<Integer> getInt(Identifier key) {
        return Optional.ofNullable((Integer)this.container.get(key.asNamespacedKey(), PersistentDataType.INTEGER));
    }

    public Optional<int[]> getIntArray(Identifier key) {
        return Optional.ofNullable((int[])this.container.get(key.asNamespacedKey(), PersistentDataType.INTEGER_ARRAY));
    }

    public Optional<Boolean> getBoolean(Identifier key) {
        return Optional.ofNullable((Boolean)this.container.get(key.asNamespacedKey(), PersistentDataType.BOOLEAN));
    }

    public Optional<Float> getFloat(Identifier key) {
        return Optional.ofNullable((Float)this.container.get(key.asNamespacedKey(), PersistentDataType.FLOAT));
    }

    public Optional<Byte> getByte(Identifier key) {
        return Optional.ofNullable((Byte)this.container.get(key.asNamespacedKey(), PersistentDataType.BYTE));
    }

    public Optional<byte[]> getByteArray(Identifier key) {
        return Optional.ofNullable((byte[])this.container.get(key.asNamespacedKey(), PersistentDataType.BYTE_ARRAY));
    }

    public PersistentDataContainer toVanilla() {
        return this.container;
    }
}

