/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

public class TextUtil {
    private static final List<TypeAdapterRegistration<?>> ADAPTERS = new ArrayList();
    public static Gson GSON = new Gson();
    public static final MiniMessage MM = MiniMessage.miniMessage();

    public static void buildGson() {
        GsonBuilder builder = new GsonBuilder().serializeNulls().excludeFieldsWithModifiers(new int[]{8, 128}).setPrettyPrinting();
        for (TypeAdapterRegistration<?> reg : ADAPTERS) {
            if (reg.hierarchy) {
                builder.registerTypeHierarchyAdapter(reg.clazz, reg.adapter);
                continue;
            }
            builder.registerTypeAdapter(reg.clazz, reg.adapter);
        }
        GSON = builder.create();
    }

    public static <T> void registerTypeAdapter(Class<T> clazz, Object adapter) {
        ADAPTERS.add(new TypeAdapterRegistration<T>(clazz, adapter, false));
        TextUtil.buildGson();
    }

    public static <T> void registerTypeHierarchyAdapter(Class<T> clazz, Object adapter) {
        ADAPTERS.add(new TypeAdapterRegistration<T>(clazz, adapter, true));
        TextUtil.buildGson();
    }

    public static List<String> convertToList(String[] arr) {
        return Arrays.asList(arr);
    }

    public static String[] convertToArray(List<String> list) {
        return (String[])list.toArray(String[]::new);
    }

    public static Component parse(String mmText) {
        return MM.deserialize((Object)mmText);
    }

    public static Component parse(String mmText, TagResolver ... resolvers) {
        return MM.deserialize(mmText, resolvers);
    }

    private record TypeAdapterRegistration<T>(Class<T> clazz, Object adapter, boolean hierarchy) {
    }
}

