/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.util;

import java.util.function.Consumer;
import java.util.function.Function;

public class Try {
    public static void run(ThrowingRunnable runnable, Consumer<Exception> handler) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            handler.accept(e);
        }
    }

    public static <T> T get(ThrowingSupplier<T> supplier, Function<Exception, T> handler) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            return handler.apply(e);
        }
    }

    public static void run(ThrowingRunnable runnable) {
        Try.run(runnable, e -> {});
    }

    public static <T> T get(ThrowingSupplier<T> supplier, T defaultValue) {
        return (T)Try.get(supplier, e -> defaultValue);
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        public void run() throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T> {
        public T get() throws Exception;
    }
}

