/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.bridge.block;

import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.github.darksoulq.abyssallib.server.bridge.Provider;
import com.github.darksoulq.abyssallib.server.bridge.block.BridgeBlock;
import com.nexomc.nexo.api.NexoBlocks;
import com.nexomc.nexo.mechanics.custom_block.chorusblock.ChorusBlockMechanic;
import com.nexomc.nexo.mechanics.custom_block.noteblock.NoteBlockMechanic;
import com.nexomc.nexo.mechanics.custom_block.stringblock.StringBlockMechanic;
import java.util.Map;
import java.util.Optional;

public class NexoBlockProvider
extends Provider<BridgeBlock<?>> {
    public NexoBlockProvider() {
        super("nexo");
    }

    @Override
    public boolean belongs(BridgeBlock<?> value) {
        return NexoBlocks.isCustomBlock((String)Identifier.of(value.id().getNamespace(), value.id().getPath()).toString());
    }

    @Override
    public Identifier getId(BridgeBlock<?> value) {
        return Identifier.of(value.id().getNamespace(), value.id().getPath());
    }

    @Override
    public BridgeBlock<?> get(Identifier id) {
        if (NexoBlocks.isNexoNoteBlock((String)id.toString())) {
            return new BridgeBlock<NoteBlockMechanic>(id, this.getPrefix(), NexoBlocks.noteBlockMechanic((String)id.toString()));
        }
        if (NexoBlocks.isNexoStringBlock((String)id.toString())) {
            return new BridgeBlock<StringBlockMechanic>(id, this.getPrefix(), NexoBlocks.stringMechanic((String)id.toString()));
        }
        if (NexoBlocks.isNexoChorusBlock((String)id.toString())) {
            return new BridgeBlock<ChorusBlockMechanic>(id, this.getPrefix(), NexoBlocks.chorusBlockMechanic((String)id.toString()));
        }
        return null;
    }

    @Override
    public Map<String, Optional<Object>> serializeData(BridgeBlock<?> value) {
        return Map.of();
    }

    @Override
    public void deserializeData(Map<String, Optional<Object>> data, BridgeBlock<?> value) {
    }
}

