/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.data;

import com.github.darksoulq.abyssallib.AbyssalLib;
import io.papermc.paper.datapack.DatapackRegistrar;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.kyori.adventure.text.Component;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class Datapack {
    private final Plugin plugin;
    private final String modid;
    private final Path outputFile;
    private final TreeMap<String, byte[]> files = new TreeMap();

    public Datapack(@NotNull Plugin plugin, @NotNull String modid) {
        this.plugin = plugin;
        this.modid = modid;
        this.outputFile = plugin.getDataFolder().toPath().resolve("pack").resolve("datapack.zip");
    }

    public void compile() {
        this.files.clear();
        try {
            this.loadFromJar();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load /data folder from plugin JAR", e);
        }
        this.put("pack.mcmeta", this.generatePackMeta());
        try {
            Files.createDirectories(this.outputFile.getParent(), new FileAttribute[0]);
            try (ZipOutputStream zip = new ZipOutputStream(Files.newOutputStream(this.outputFile, new OpenOption[0]));){
                for (Map.Entry<String, byte[]> entry : this.files.entrySet()) {
                    zip.putNextEntry(new ZipEntry(entry.getKey()));
                    zip.write(entry.getValue());
                    zip.closeEntry();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write datapack ZIP: " + String.valueOf(this.outputFile), e);
        }
    }

    public void register(@NotNull Component title) {
        this.compile();
        AbyssalLib.DATAPACK_REGISTRAR.register(this.outputFile, this.modid, title);
    }

    private void loadFromJar() throws IOException {
        Path jarPath = Paths.get(this.plugin.getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), new String[0]);
        try (JarFile jar = new JarFile(jarPath.toFile());){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || !name.startsWith("data/")) continue;
                try (BufferedInputStream in = new BufferedInputStream(jar.getInputStream(entry));){
                    this.files.put(name, this.readAllBytes(in));
                }
            }
        }
    }

    private byte[] readAllBytes(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        while ((read = in.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, read);
        }
        return buffer.toByteArray();
    }

    @NotNull
    private String generatePackMeta() {
        return "{\n  \"pack\": {\n    \"pack_format\": 40,\n    \"description\": \"" + this.modid + " internal Datapack\"\n  }\n}";
    }

    private void put(@NotNull String path, @NotNull String content) {
        this.files.put(path, content.getBytes(StandardCharsets.UTF_8));
    }

    private void put(@NotNull String path, byte[] data) {
        this.files.put(path, data);
    }

    @NotNull
    public Path getOutputFile() {
        return this.outputFile;
    }

    @ApiStatus.Internal
    public static class Registrar {
        private final DatapackRegistrar registrar;

        public Registrar(@NotNull DatapackRegistrar registrar) {
            this.registrar = registrar;
        }

        public void register(@NotNull Path path, @NotNull String id, @NotNull Component title) {
            try {
                this.registrar.discoverPack(path, id, config -> {
                    config.title(title);
                    config.autoEnableOnServerStart(true);
                });
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to register datapack: " + id, e);
            }
        }
    }
}

