/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.event;

import com.github.darksoulq.abyssallib.server.event.SubscribeEvent;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class EventBus {
    private final Plugin plugin;
    private final Set<Object> registeredObjects = new HashSet<Object>();

    public EventBus(Plugin plugin) {
        this.plugin = plugin;
    }

    public void register(Object listenerObject) {
        if (!this.registeredObjects.add(listenerObject)) {
            return;
        }
        Listener dynamicListener = new Listener(this){};
        for (Method method : listenerObject.getClass().getDeclaredMethods()) {
            MethodHandle handle;
            if (!method.isAnnotationPresent(SubscribeEvent.class)) continue;
            if (method.getParameterCount() != 1) {
                throw new IllegalArgumentException("Method " + String.valueOf(method) + " must have exactly one parameter.");
            }
            Class<?> eventClass = method.getParameterTypes()[0];
            if (!Event.class.isAssignableFrom(eventClass)) {
                throw new IllegalArgumentException("Parameter must be a Bukkit event.");
            }
            SubscribeEvent annotation = method.getAnnotation(SubscribeEvent.class);
            EventPriority priority = annotation.priority();
            boolean ignoreCancelled = annotation.ignoreCancelled();
            method.setAccessible(true);
            try {
                handle = MethodHandles.lookup().unreflect(method).bindTo(listenerObject);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could not create method handle for " + String.valueOf(method), e);
            }
            Bukkit.getPluginManager().registerEvent(eventClass, dynamicListener, priority, (listener, event) -> {
                if (eventClass.isAssignableFrom(event.getClass())) {
                    try {
                        handle.invokeWithArguments(event);
                    }
                    catch (Throwable t) {
                        this.plugin.getLogger().severe("Failed to invoke event handler: " + t.getMessage());
                        t.printStackTrace();
                    }
                }
            }, this.plugin, ignoreCancelled);
        }
    }

    public static <T extends Event> T post(T event) {
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }
}

