/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.event.custom.multiblock;

import com.github.darksoulq.abyssallib.world.multiblock.Multiblock;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiblockBreakEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Cause cause;
    private final Multiblock multiblock;
    @Nullable
    private final Entity eCause;
    @Nullable
    private final Block bCause;
    @Nullable
    private final Player player;
    @Nullable
    private final ItemStack tool;
    private boolean cancelled = false;

    public MultiblockBreakEvent(@Nullable Player player, @NotNull Multiblock multiblock, @Nullable ItemStack tool) {
        this.cause = Cause.PLAYER;
        this.eCause = null;
        this.bCause = null;
        this.player = player;
        this.multiblock = multiblock;
        this.tool = tool;
    }

    public MultiblockBreakEvent(@Nullable Entity entity, @NotNull Multiblock multiblock) {
        this.cause = Cause.ENTITY_EXPLODE;
        this.eCause = entity;
        this.bCause = null;
        this.player = null;
        this.multiblock = multiblock;
        this.tool = null;
    }

    public MultiblockBreakEvent(@Nullable Block block, @NotNull Multiblock multiblock) {
        this.cause = Cause.BLOCK_EXPLODE;
        this.eCause = null;
        this.bCause = block;
        this.player = null;
        this.multiblock = multiblock;
        this.tool = null;
    }

    @NotNull
    public Multiblock getMultiblock() {
        return this.multiblock;
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    @Nullable
    public Block getExplodingBlock() {
        return this.bCause;
    }

    @Nullable
    public Entity getExplodingEntity() {
        return this.eCause;
    }

    @Nullable
    public ItemStack getTool() {
        return this.tool;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static enum Cause {
        PLAYER,
        ENTITY_EXPLODE,
        BLOCK_EXPLODE;

    }
}

