/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.packet;

import com.github.darksoulq.abyssallib.AbyssalLib;
import com.github.darksoulq.abyssallib.server.event.custom.server.PacketReceiveEvent;
import com.github.darksoulq.abyssallib.server.event.custom.server.PacketSendEvent;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import java.util.WeakHashMap;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public final class PacketInterceptor {
    @NotNull
    private static final String HANDLER = "abyssal_packet_listener";
    @NotNull
    private static final WeakHashMap<ChannelPipeline, Boolean> injected = new WeakHashMap();

    public static void inject(final @NotNull Player player) {
        ServerPlayer nms = ((CraftPlayer)player).getHandle();
        Connection connection = nms.connection.connection;
        ChannelPipeline pipeline = connection.channel.pipeline();
        if (injected.containsKey(pipeline) || pipeline.get(HANDLER) != null) {
            return;
        }
        ChannelDuplexHandler handler = new ChannelDuplexHandler(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                if (msg instanceof Packet) {
                    Packet packet = (Packet)msg;
                    PacketReceiveEvent event = new PacketReceiveEvent(player, packet, true);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                }
                super.channelRead(ctx, msg);
            }

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                if (msg instanceof Packet) {
                    Packet packet = (Packet)msg;
                    PacketSendEvent event = new PacketSendEvent(player, packet, true);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        promise.setSuccess();
                        return;
                    }
                }
                super.write(ctx, msg, promise);
            }
        };
        try {
            pipeline.addBefore("packet_handler", HANDLER, (ChannelHandler)handler);
            injected.put(pipeline, true);
        }
        catch (Throwable t) {
            AbyssalLib.getInstance().getLogger().severe("Failed to inject packet handler: " + t.getMessage());
        }
    }

    public static void uninject(@NotNull Player player) {
        ServerPlayer nms = ((CraftPlayer)player).getHandle();
        Connection connection = nms.connection.connection;
        ChannelPipeline pipeline = connection.channel.pipeline();
        try {
            if (pipeline.get(HANDLER) != null) {
                pipeline.remove(HANDLER);
                injected.remove(pipeline);
            }
        }
        catch (Throwable t) {
            AbyssalLib.getInstance().getLogger().severe("Failed to uninject packet handler: " + t.getMessage());
        }
    }
}

