/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.registry;

import com.github.darksoulq.abyssallib.AbyssalLib;
import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.github.darksoulq.abyssallib.server.event.custom.server.RegistryApplyEvent;
import com.github.darksoulq.abyssallib.server.registry.Registries;
import com.github.darksoulq.abyssallib.server.registry.Registry;
import com.github.darksoulq.abyssallib.server.registry.object.Holder;
import com.github.darksoulq.abyssallib.world.block.CustomBlock;
import com.github.darksoulq.abyssallib.world.entity.DamageType;
import com.github.darksoulq.abyssallib.world.item.Item;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public final class DeferredRegistry<T> {
    private final Registry<T> registry;
    private final String pluginId;
    private final Map<String, Holder<T>> entries = new HashMap<String, Holder<T>>();

    private DeferredRegistry(@NotNull Registry<T> registry, @NotNull String pluginId) {
        this.registry = registry;
        this.pluginId = pluginId;
    }

    public static <T> DeferredRegistry<T> create(Registry<T> registry, String pluginId) {
        return new DeferredRegistry<T>(registry, pluginId);
    }

    public Holder<T> register(String name, Function<Identifier, T> supplier) {
        if (this.entries.containsKey(name)) {
            throw new IllegalStateException("Duplicate deferred registration: " + this.pluginId + ":" + name);
        }
        Identifier id = Identifier.of(this.pluginId, name);
        Holder<Object> holder = new Holder<Object>(() -> supplier.apply(id));
        this.entries.put(name, holder);
        return holder;
    }

    public void apply() {
        RegistryApplyEvent<T> event = new RegistryApplyEvent<T>(this.registry, this);
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            AbyssalLib.getInstance().getLogger().info("Registry apply cancelled for mod: " + this.pluginId);
            return;
        }
        ArrayList<DamageType> damageTypes = new ArrayList<DamageType>();
        for (Map.Entry<String, Holder<T>> entries : this.entries.entrySet()) {
            CustomBlock block;
            T value = entries.getValue().get();
            this.registry.register(this.pluginId + ":" + entries.getKey(), value);
            if (value instanceof DamageType) {
                damageTypes.add((DamageType)value);
            }
            if (!(value instanceof CustomBlock) || !(block = (CustomBlock)value).generateItem()) continue;
            Item blockItem = block.getItem().get();
            Registries.ITEMS.register(this.pluginId + ":" + entries.getKey(), blockItem);
        }
        if (!damageTypes.isEmpty()) {
            AbyssalLib.DAMAGE_TYPE_REGISTRAR.register(damageTypes);
        }
        this.entries.clear();
    }

    public Collection<Holder<T>> getEntries() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    public String getPluginId() {
        return this.pluginId;
    }
}

