/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.resource;

import com.github.darksoulq.abyssallib.AbyssalLib;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PackServer {
    private String host;
    private int port;
    private HttpServer server;
    private final Map<String, Path> registeredPaths = new HashMap<String, Path>();

    public void start(String host, int port) {
        try {
            this.host = host;
            this.port = port;
            this.server = HttpServer.create(new InetSocketAddress(host, port), 0);
            this.server.createContext("/", exchange -> {
                String path = exchange.getRequestURI().getPath();
                String[] parts = path.split("/");
                if (parts.length != 3 || !parts[2].equals("resourcepack.zip")) {
                    exchange.sendResponseHeaders(404, -1L);
                    return;
                }
                String modid = parts[1];
                Path file = this.registeredPaths.get(modid);
                if (file == null || !Files.exists(file, new LinkOption[0])) {
                    exchange.sendResponseHeaders(404, -1L);
                    return;
                }
                exchange.getResponseHeaders().add("Content-Type", "application/zip");
                exchange.sendResponseHeaders(200, Files.size(file));
                try (OutputStream os = exchange.getResponseBody();){
                    Files.copy(file, os);
                }
            });
            this.server.setExecutor(null);
            this.server.start();
            AbyssalLib.getInstance().getLogger().info("Hosting resource packs at http://" + host + ":" + port);
        }
        catch (IOException e) {
            AbyssalLib.getInstance().getLogger().severe("ResourcePackServer failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop(0);
        }
    }

    public void registerResourcePack(String pluginid, Path resourcePackFile) {
        this.registeredPaths.put(pluginid, resourcePackFile);
        AbyssalLib.getInstance().getLogger().info("Registered resource pack for /" + pluginid + "/resourcepack.zip");
    }

    public void unregisterResourcePack(String pluginid) {
        this.registeredPaths.remove(pluginid);
        AbyssalLib.getInstance().getLogger().info("Unregistered resource pack for /" + pluginid + "/resourcepack.zip");
    }

    public String getUrl(String modid) {
        return "http://" + this.host + ":" + this.port + "/" + modid + "/resourcepack.zip";
    }

    public Set<String> registeredModIDs() {
        return this.registeredPaths.keySet();
    }
}

