/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.resource.asset;

import com.github.darksoulq.abyssallib.server.resource.asset.Asset;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class Lang
implements Asset {
    private final String namespace;
    private final String lang;
    private byte[] rawData = null;
    private final Map<String, String> values = new LinkedHashMap<String, String>();

    public Lang(@NotNull String namespace, @NotNull String lang) {
        this.namespace = namespace;
        this.lang = lang;
    }

    public Lang(@NotNull String namespace, @NotNull String lang, byte[] data) {
        this.namespace = namespace;
        this.lang = lang;
        this.rawData = data;
    }

    public Lang(@NotNull Plugin plugin, @NotNull String namespace, @NotNull String lang) {
        this.namespace = namespace;
        this.lang = lang;
        try (InputStream in = plugin.getResource("resourcepack/" + namespace + "/lang/" + lang + ".json");){
            if (in != null) {
                JsonObject obj = JsonParser.parseReader((Reader)new InputStreamReader(in)).getAsJsonObject();
                for (Map.Entry e : obj.entrySet()) {
                    this.values.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load lang file", e);
        }
    }

    public void put(@NotNull String key, @NotNull String value) {
        this.values.put(key, value);
    }

    @Override
    public void emit(@NotNull Map<String, byte[]> files) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject json = new JsonObject();
        this.values.forEach((arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
        String prettyJson = gson.toJson((JsonElement)json);
        files.put("assets/" + this.namespace + "/lang/" + this.lang + ".json", prettyJson.getBytes(StandardCharsets.UTF_8));
    }
}

