/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.resource.asset;

import com.github.darksoulq.abyssallib.server.resource.asset.Asset;
import com.github.darksoulq.abyssallib.server.resource.asset.Texture;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.plugin.Plugin;
import org.checkerframework.common.value.qual.IntRange;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class Model
implements Asset {
    private final String namespace;
    private final String path;
    private final byte[] rawData;
    private int[] textureSize = null;
    private GuiLight guiLight = GuiLight.FRONT;
    private boolean ambientOcclusion = true;
    private final List<Element> elements = new ArrayList<Element>();
    private final Map<String, Texture> textures = new HashMap<String, Texture>();
    private final Map<String, Display> display = new HashMap<String, Display>();
    private String parent;

    public Model(@NotNull Plugin plugin, @NotNull String namespace, @NotNull String path) {
        this.namespace = namespace;
        this.path = path;
        String resourcePath = "resourcepack/" + namespace + "/models/" + path + ".json";
        try (InputStream in = plugin.getResource(resourcePath);){
            if (in == null) {
                throw new IllegalStateException("Model not found in plugin JAR at: " + resourcePath);
            }
            this.rawData = in.readAllBytes();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load model from plugin JAR: " + resourcePath, e);
        }
    }

    public Model(@NotNull String namespace, @NotNull String path) {
        this(namespace, path, 16, 16);
    }

    public Model(@NotNull String namespace, @NotNull String path, int texWidth, int texHeight) {
        this.namespace = namespace;
        this.path = path;
        this.rawData = null;
        this.textureSize = new int[]{texWidth, texHeight};
    }

    public Model(String namespace, String path, byte[] data) {
        this.namespace = namespace;
        this.path = path;
        this.rawData = data;
    }

    @NotNull
    public Model parent(@NotNull String model) {
        this.parent = model;
        return this;
    }

    @NotNull
    public Model guiLight(GuiLight mode) {
        this.guiLight = mode;
        return this;
    }

    @NotNull
    public Model ambientOcculsion(boolean ambientOcclusion) {
        this.ambientOcclusion = ambientOcclusion;
        return this;
    }

    @NotNull
    public Model texture(@NotNull String key, @NotNull Texture value) {
        this.textures.put(key, value);
        return this;
    }

    @NotNull
    public Element addElement(@NotNull float[] from, @NotNull float[] to) {
        Element element = new Element(from, to);
        this.elements.add(element);
        return element;
    }

    @NotNull
    public Model display(@NotNull String perspective, @NotNull Display d) {
        this.display.put(perspective, d);
        return this;
    }

    @NotNull
    public String file() {
        return this.namespace + ":" + this.path;
    }

    @Override
    public void emit(@NotNull Map<String, byte[]> files) {
        if (this.rawData != null) {
            files.put("assets/" + this.namespace + "/models/" + this.path + ".json", this.rawData);
            return;
        }
        JsonObject obj = new JsonObject();
        if (this.textureSize[0] != 16 && this.textureSize[1] != 16) {
            obj.add("texture_size", (JsonElement)this.toArray(this.textureSize));
        }
        if (this.parent != null) {
            obj.addProperty("parent", this.parent);
        }
        obj.addProperty("gui_light", this.guiLight.name().toLowerCase());
        if (!this.ambientOcclusion) {
            obj.addProperty("ambientocclusion", Boolean.valueOf(false));
        }
        if (!this.textures.isEmpty()) {
            JsonObject tex = new JsonObject();
            for (Map.Entry entry : this.textures.entrySet()) {
                tex.addProperty((String)entry.getKey(), ((Texture)entry.getValue()).file());
            }
            obj.add("textures", (JsonElement)tex);
        }
        if (!this.elements.isEmpty()) {
            JsonArray array = new JsonArray();
            for (Element element : this.elements) {
                array.add((JsonElement)element.toJson());
            }
            obj.add("elements", (JsonElement)array);
        }
        if (!this.display.isEmpty()) {
            JsonObject displayObj = new JsonObject();
            for (Map.Entry entry : this.display.entrySet()) {
                displayObj.add((String)entry.getKey(), (JsonElement)((Display)entry.getValue()).toJson());
            }
            obj.add("display", (JsonElement)displayObj);
        }
        files.put("assets/" + this.namespace + "/models/" + this.path + ".json", new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)obj).getBytes(StandardCharsets.UTF_8));
    }

    private JsonArray toArray(int[] arr) {
        JsonArray a = new JsonArray();
        for (int f : arr) {
            a.add((Number)f);
        }
        return a;
    }

    public static enum GuiLight {
        FRONT,
        SIDE;

    }

    @ApiStatus.Experimental
    public static class Element {
        private int lightEmission = 0;
        private boolean shade = true;
        private final float[] from;
        private final float[] to;
        private Rotation rotation;
        private final Map<String, Face> faces = new HashMap<String, Face>();

        public Element(float @NotNull [] from, float @NotNull [] to) {
            this.from = from;
            this.to = to;
        }

        @NotNull
        public Element rotation(float[] origin, String axis, float angle, boolean rescale) {
            this.rotation = new Rotation(origin, axis, angle, rescale);
            return this;
        }

        @NotNull
        public Element face(String dir, Face face) {
            this.faces.put(dir, face);
            return this;
        }

        @NotNull
        public Element lightEmission(@IntRange(from=0L, to=15L) int lightEmission) {
            this.lightEmission = lightEmission;
            return this;
        }

        @NotNull
        public Element shade(boolean shade) {
            this.shade = shade;
            return this;
        }

        @NotNull
        public JsonObject toJson() {
            JsonObject o = new JsonObject();
            o.add("from", (JsonElement)this.toArray(this.from));
            o.add("to", (JsonElement)this.toArray(this.to));
            if (this.rotation != null) {
                o.add("rotation", (JsonElement)this.rotation.toJson());
            }
            if (this.lightEmission != 0) {
                o.addProperty("light_emission", (Number)this.lightEmission);
            }
            if (!this.shade) {
                o.addProperty("shade", Boolean.valueOf(false));
            }
            if (this.lightEmission != 0) {
                o.addProperty("light_emission", (Number)this.lightEmission);
            }
            JsonObject faceObj = new JsonObject();
            for (Map.Entry<String, Face> entry : this.faces.entrySet()) {
                faceObj.add(entry.getKey(), (JsonElement)entry.getValue().toJson());
            }
            o.add("faces", (JsonElement)faceObj);
            return o;
        }

        private JsonArray toArray(float[] arr) {
            JsonArray a = new JsonArray();
            for (float f : arr) {
                a.add((Number)Float.valueOf(f));
            }
            return a;
        }

        @ApiStatus.Experimental
        private static class Rotation {
            float[] origin;
            String axis;
            float angle;
            boolean rescale;

            Rotation(float[] origin, String axis, float angle, boolean rescale) {
                this.origin = origin;
                this.axis = axis;
                this.angle = angle;
                this.rescale = rescale;
            }

            JsonObject toJson() {
                JsonObject o = new JsonObject();
                o.add("origin", (JsonElement)this.toArray(this.origin));
                o.addProperty("axis", this.axis);
                o.addProperty("angle", (Number)Float.valueOf(this.angle));
                o.addProperty("rescale", Boolean.valueOf(this.rescale));
                return o;
            }

            private JsonArray toArray(float[] arr) {
                JsonArray a = new JsonArray();
                for (float f : arr) {
                    a.add((Number)Float.valueOf(f));
                }
                return a;
            }
        }
    }

    @ApiStatus.Experimental
    public static class Display {
        private float[] rotation = new float[3];
        private float[] translation = new float[3];
        private float[] scale = new float[]{1.0f, 1.0f, 1.0f};

        @NotNull
        public Display rotation(float x, float y, float z) {
            this.rotation = new float[]{x, y, z};
            return this;
        }

        @NotNull
        public Display translation(float x, float y, float z) {
            this.translation = new float[]{x, y, z};
            return this;
        }

        @NotNull
        public Display scale(float x, float y, float z) {
            this.scale = new float[]{x, y, z};
            return this;
        }

        @NotNull
        public JsonObject toJson() {
            JsonObject obj = new JsonObject();
            obj.add("rotation", (JsonElement)this.toArray(this.rotation));
            obj.add("translation", (JsonElement)this.toArray(this.translation));
            obj.add("scale", (JsonElement)this.toArray(this.scale));
            return obj;
        }

        @NotNull
        private JsonArray toArray(float[] vals) {
            JsonArray a = new JsonArray();
            for (float v : vals) {
                a.add((Number)Float.valueOf(v));
            }
            return a;
        }
    }

    @ApiStatus.Experimental
    public static class Face {
        private final String texture;
        private float[] uv;
        private String cullface;
        private Integer rotation;
        private Integer tintindex;

        public Face(@NotNull String texture) {
            this.texture = texture;
        }

        @NotNull
        public Face uv(float u1, float v1, float u2, float v2) {
            this.uv = new float[]{u1, v1, u2, v2};
            return this;
        }

        @NotNull
        public Face cullface(@NotNull String face) {
            this.cullface = face;
            return this;
        }

        @NotNull
        public Face rotation(int angle) {
            this.rotation = angle;
            return this;
        }

        @NotNull
        public Face tint(int index) {
            this.tintindex = index;
            return this;
        }

        @NotNull
        public JsonObject toJson() {
            JsonObject o = new JsonObject();
            o.addProperty("texture", this.texture);
            if (this.uv != null) {
                o.add("uv", (JsonElement)this.toArray(this.uv));
            }
            if (this.cullface != null) {
                o.addProperty("cullface", this.cullface);
            }
            if (this.rotation != null) {
                o.addProperty("rotation", (Number)this.rotation);
            }
            if (this.tintindex != null) {
                o.addProperty("tintindex", (Number)this.tintindex);
            }
            return o;
        }

        private JsonArray toArray(float[] arr) {
            JsonArray a = new JsonArray();
            for (float f : arr) {
                a.add((Number)Float.valueOf(f));
            }
            return a;
        }
    }
}

