/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.resource.asset.definition;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface Tint {
    public String id();

    public Map<String, Object> toJson();

    public static class Grass
    implements Tint {
        public int temperature = 0;
        public int downfall = 0;

        public Grass(int temperature, int downfall) {
            this.temperature = temperature;
            this.downfall = downfall;
        }

        @Override
        public String id() {
            return "minecraft:grass";
        }

        @Override
        public Map<String, Object> toJson() {
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
            json.put("type", this.id());
            json.put("temperature", this.temperature);
            json.put("downfall", this.downfall);
            return json;
        }
    }

    public static class Team
    implements Tint {
        public String type = "int";
        public int value = 0;
        public int[] values = new int[3];

        public Team(String type) {
            if (!"int".equals(type) && !"list".equals(type)) {
                throw new IllegalArgumentException(type + " is not a valid type!");
            }
            this.type = type;
        }

        public Team value(int value) {
            this.value = value;
            return this;
        }

        public Team values(int[] values) {
            this.values = values;
            return this;
        }

        @Override
        public String id() {
            return "minecraft:team";
        }

        @Override
        public Map<String, Object> toJson() {
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
            json.put("type", this.id());
            json.put("value", "int".equals(this.type) ? Integer.valueOf(this.value) : List.of(this.values));
            return json;
        }
    }

    public static class Potion
    implements Tint {
        public String type = "int";
        public int value = 0;
        public int[] values = new int[3];

        public Potion(String type) {
            if (!"int".equals(type) && !"list".equals(type)) {
                throw new IllegalArgumentException(type + " is not a valid type!");
            }
            this.type = type;
        }

        public Potion value(int value) {
            this.value = value;
            return this;
        }

        public Potion values(int[] values) {
            this.values = values;
            return this;
        }

        @Override
        public String id() {
            return "minecraft:potion";
        }

        @Override
        public Map<String, Object> toJson() {
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
            json.put("type", this.id());
            json.put("value", "int".equals(this.type) ? Integer.valueOf(this.value) : List.of(this.values));
            return json;
        }
    }

    public static class MapColor
    implements Tint {
        public String type = "int";
        public int value = 0;
        public int[] values = new int[3];

        public MapColor(String type) {
            if (!"int".equals(type) && !"list".equals(type)) {
                throw new IllegalArgumentException(type + " is not a valid type!");
            }
            this.type = type;
        }

        public MapColor value(int value) {
            this.value = value;
            return this;
        }

        public MapColor values(int[] values) {
            this.values = values;
            return this;
        }

        @Override
        public String id() {
            return "minecraft:map_color";
        }

        @Override
        public Map<String, Object> toJson() {
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
            json.put("type", this.id());
            json.put("value", "int".equals(this.type) ? Integer.valueOf(this.value) : List.of(this.values));
            return json;
        }
    }

    public static class Firework
    implements Tint {
        public String type = "int";
        public int value = 0;
        public int[] values = new int[3];

        public Firework(String type) {
            if (!"int".equals(type) && !"list".equals(type)) {
                throw new IllegalArgumentException(type + " is not a valid type!");
            }
            this.type = type;
        }

        public Firework value(int value) {
            this.value = value;
            return this;
        }

        public Firework values(int[] values) {
            this.values = values;
            return this;
        }

        @Override
        public String id() {
            return "minecraft:firework";
        }

        @Override
        public Map<String, Object> toJson() {
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
            json.put("type", this.id());
            json.put("value", "int".equals(this.type) ? Integer.valueOf(this.value) : List.of(this.values));
            return json;
        }
    }

    public static class Dye
    implements Tint {
        public String type = "int";
        public int value = 0;
        public int[] values = new int[3];

        public Dye(String type) {
            if (!"int".equals(type) && !"list".equals(type)) {
                throw new IllegalArgumentException(type + " is not a valid type!");
            }
            this.type = type;
        }

        public Dye value(int value) {
            this.value = value;
            return this;
        }

        public Dye values(int[] values) {
            this.values = values;
            return this;
        }

        @Override
        public String id() {
            return "minecraft:dye";
        }

        @Override
        public Map<String, Object> toJson() {
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
            json.put("type", this.id());
            json.put("value", "int".equals(this.type) ? Integer.valueOf(this.value) : List.of(this.values));
            return json;
        }
    }

    public static class CustomModelData
    implements Tint {
        public String type = "int";
        public int index;
        public int value = 0;
        public int[] values = new int[3];

        public CustomModelData(String type, int index) {
            if (!"int".equals(type) && !"list".equals(type)) {
                throw new IllegalArgumentException(type + " is not a valid type!");
            }
            this.type = type;
            this.index = index;
        }

        public CustomModelData value(int value) {
            this.value = value;
            return this;
        }

        public CustomModelData values(int[] values) {
            this.values = values;
            return this;
        }

        @Override
        public String id() {
            return "minecraft:custom_model_data";
        }

        @Override
        public Map<String, Object> toJson() {
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
            json.put("type", this.id());
            json.put("index", this.index);
            json.put("value", "int".equals(this.type) ? Integer.valueOf(this.value) : List.of(this.values));
            return json;
        }
    }

    public static class Constant
    implements Tint {
        private String type = "int";
        private int value = 0;
        private int[] values = new int[3];

        public Constant(String type) {
            if (!"int".equals(type) && !"list".equals(type)) {
                throw new IllegalArgumentException(type + " is not a valid type!");
            }
            this.type = type;
        }

        public Constant value(int value) {
            this.value = value;
            return this;
        }

        public Constant values(int[] values) {
            this.values = values;
            return this;
        }

        @Override
        public String id() {
            return "minecraft:constant";
        }

        @Override
        public Map<String, Object> toJson() {
            LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
            json.put("type", this.id());
            json.put("value", "int".equals(this.type) ? Integer.valueOf(this.value) : List.of(this.values));
            return json;
        }
    }
}

