/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.resource.util;

import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class BookLoader {
    private static final Gson GSON = new GsonBuilder().create();
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();

    public static ItemStack load(Plugin plugin, Identifier id) {
        Iterator iterator;
        String path = "books/" + id.getPath() + ".json";
        InputStream in = plugin.getResource(path);
        if (in == null) {
            throw new IllegalStateException("Book resource not found: " + path);
        }
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        try {
            JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            String title = root.get("title").getAsString();
            String author = root.get("author").getAsString();
            JsonArray pages = root.getAsJsonArray("pages");
            ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
            BookMeta meta = (BookMeta)book.getItemMeta();
            meta.setTitle(title);
            meta.setAuthor(author);
            for (JsonElement pageElement : pages) {
                if (!pageElement.isJsonArray()) continue;
                JsonArray lines = pageElement.getAsJsonArray();
                StringBuilder pageText = new StringBuilder();
                for (JsonElement lineElement : lines) {
                    pageText.append(lineElement.getAsString()).append("\n");
                }
                Component pageComponent = MINI_MESSAGE.deserialize((Object)pageText.toString().trim());
                meta.addPages(new Component[]{pageComponent});
            }
            book.setItemMeta((ItemMeta)meta);
            iterator = book;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load book: " + String.valueOf(id), e);
            }
        }
        reader.close();
        return iterator;
    }
}

