/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.data.internal;

import com.github.darksoulq.abyssallib.AbyssalLib;
import com.github.darksoulq.abyssallib.world.item.map.BaseMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public final class MapLoader {
    private static final File ROOT_DIR = new File(AbyssalLib.getInstance().getDataFolder(), "maps");

    public static void load() {
        if (!ROOT_DIR.exists()) {
            return;
        }
        for (File pluginDir : Objects.requireNonNull(ROOT_DIR.listFiles(File::isDirectory))) {
            MapLoader.loadMapsFromPlugin(pluginDir);
        }
    }

    private static void loadMapsFromPlugin(File pluginDir) {
        File[] mapFiles = pluginDir.listFiles((dir, name) -> name.endsWith(".json"));
        if (mapFiles == null) {
            return;
        }
        for (File file : mapFiles) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                Plugin owningPlugin;
                String className = reader.readLine();
                int mapId = Integer.parseInt(reader.readLine());
                Class<?> clazz = Class.forName(className);
                if (!BaseMap.class.isAssignableFrom(clazz)) continue;
                Constructor<?> constructor = clazz.getConstructor(Plugin.class, MapView.class);
                MapView mapView = Bukkit.getMap((int)((short)mapId));
                if (mapView == null || (owningPlugin = Bukkit.getPluginManager().getPlugin(pluginDir.getName())) == null) continue;
                constructor.newInstance(owningPlugin, mapView);
            }
            catch (Exception e) {
                AbyssalLib.getInstance().getLogger().warning("Failed to load map from: " + file.getName());
            }
        }
    }

    public static void saveMetadata(BaseMap map, Class<?> clazz, int mapId) {
        Plugin plugin = map.getPlugin();
        File pluginDir = new File(ROOT_DIR, plugin.getName());
        if (!pluginDir.exists()) {
            pluginDir.mkdirs();
        }
        File file = new File(pluginDir, clazz.getSimpleName() + ".json");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(clazz.getName());
            writer.newLine();
            writer.write(String.valueOf(mapId));
        }
        catch (IOException e) {
            plugin.getLogger().warning("Failed to save metadata for map: " + clazz.getSimpleName());
            e.printStackTrace();
        }
    }
}

