/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.data.statistic;

import com.github.darksoulq.abyssallib.AbyssalLib;
import com.github.darksoulq.abyssallib.common.database.Database;
import com.github.darksoulq.abyssallib.common.database.impl.sqlite.SqliteDatabase;
import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.github.darksoulq.abyssallib.server.registry.Registries;
import com.github.darksoulq.abyssallib.world.data.statistic.Statistic;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerStatistics {
    private static final Map<UUID, PlayerStatistics> CACHE = new ConcurrentHashMap<UUID, PlayerStatistics>();
    private static Database DATABASE = new SqliteDatabase(new File(AbyssalLib.getInstance().getDataFolder(), "player_statistics.db"));
    private final UUID uuid;
    private final Map<Identifier, Statistic> stats = new ConcurrentHashMap<Identifier, Statistic>();

    private PlayerStatistics(UUID uuid) {
        this.uuid = uuid;
        this.load();
    }

    public static void init() {
        try {
            DATABASE.connect();
            PlayerStatistics.initTable();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PlayerStatistics of(Player player) {
        return PlayerStatistics.of(player.getUniqueId());
    }

    public static PlayerStatistics of(UUID uuid) {
        return CACHE.computeIfAbsent(uuid, PlayerStatistics::new);
    }

    public Statistic get(Identifier id) {
        Statistic stat = this.stats.get(id);
        return stat != null ? stat.clone() : null;
    }

    public void set(Statistic stat) {
        this.stats.put(stat.getId(), stat.clone());
        this.save(stat);
    }

    public List<Statistic> get() {
        return this.stats.values().stream().toList();
    }

    private void save(Statistic stat) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)AbyssalLib.getInstance(), () -> DATABASE.executor().table("player_statistics").insert().value("uuid", this.uuid.toString()).value("key", stat.getId().toString()).value("value", stat.getValue().toString()).execute());
    }

    private void load() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)AbyssalLib.getInstance(), () -> {
            List<Map.Entry> rows = DATABASE.executor().table("player_statistics").where("uuid = ?", this.uuid.toString()).select(rs -> Map.entry(rs.getString("key"), rs.getString("value")));
            ConcurrentHashMap<Identifier, Statistic> temp = new ConcurrentHashMap<Identifier, Statistic>();
            if (rows.isEmpty()) {
                Registries.STATISTICS.getAll().forEach((key, stat) -> temp.put(Identifier.of(key), stat.clone()));
            }
            for (Map.Entry entry : rows) {
                Identifier id = Identifier.of((String)entry.getKey());
                if (!Registries.STATISTICS.contains(id.toString())) {
                    AbyssalLib.getInstance().getLogger().warning("Statistic not registered: " + String.valueOf(id));
                    continue;
                }
                Statistic template = Registries.STATISTICS.get(id.toString()).clone();
                Object value = this.deserialize((String)entry.getValue(), template.getClass(), template.getValue());
                template.setValue(value);
                temp.put(id, template);
            }
            this.stats.clear();
            this.stats.putAll(temp);
        });
    }

    private <T> T deserialize(String value, Class<? extends Statistic> type, Object fallback) {
        try {
            if (Statistic.IntStatistic.class.isAssignableFrom(type)) {
                return (T)Integer.valueOf(value);
            }
            if (Statistic.FloatStatistic.class.isAssignableFrom(type)) {
                return (T)Float.valueOf(value);
            }
            if (Statistic.BooleanStatistic.class.isAssignableFrom(type)) {
                return (T)Boolean.valueOf(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)fallback;
    }

    private static void initTable() {
        DATABASE.executor().table("player_statistics").create().ifNotExists().column("uuid", "TEXT").column("key", "TEXT").column("value", "TEXT").primaryKey("uuid", "key").execute();
    }
}

