/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.entity;

import com.github.darksoulq.abyssallib.common.util.Identifier;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.DamageTypeRegistryEntry;
import io.papermc.paper.registry.event.RegistryComposeEvent;
import io.papermc.paper.registry.keys.DamageTypeKeys;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.bukkit.Location;
import org.bukkit.damage.DamageEffect;
import org.bukkit.damage.DamageScaling;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DeathMessageType;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class DamageType {
    private Identifier id;
    private DamageEffect effect = DamageEffect.HURT;
    private DamageScaling scaling = DamageScaling.NEVER;
    private DeathMessageType messageType = DeathMessageType.DEFAULT;
    private float exhaustion = 0.0f;

    public DamageType(Identifier id) {
        this.id = id;
    }

    public DamageSource withCause(Entity cause) {
        org.bukkit.damage.DamageType dmg = (org.bukkit.damage.DamageType)RegistryAccess.registryAccess().getRegistry(RegistryKey.DAMAGE_TYPE).getOrThrow(this.id.asNamespacedKey());
        return DamageSource.builder((org.bukkit.damage.DamageType)dmg).withCausingEntity(cause).build();
    }

    public DamageSource withDirect(Entity direct) {
        org.bukkit.damage.DamageType dmg = (org.bukkit.damage.DamageType)RegistryAccess.registryAccess().getRegistry(RegistryKey.DAMAGE_TYPE).getOrThrow(this.id.asNamespacedKey());
        return DamageSource.builder((org.bukkit.damage.DamageType)dmg).withDirectEntity(direct).build();
    }

    public DamageSource withLocation(Location loc) {
        org.bukkit.damage.DamageType dmg = (org.bukkit.damage.DamageType)RegistryAccess.registryAccess().getRegistry(RegistryKey.DAMAGE_TYPE).getOrThrow(this.id.asNamespacedKey());
        return DamageSource.builder((org.bukkit.damage.DamageType)dmg).withDamageLocation(loc).build();
    }

    public static Builder builder(Identifier id) {
        return new Builder(id);
    }

    protected static class Builder {
        private Identifier id;
        private DamageEffect effect = DamageEffect.HURT;
        private DamageScaling scaling = DamageScaling.NEVER;
        private DeathMessageType messageType = DeathMessageType.DEFAULT;
        private float exhaustion = 0.0f;

        public Builder(Identifier id) {
            this.id = id;
        }

        public Builder damageEffect(DamageEffect effect) {
            this.effect = effect;
            return this;
        }

        public Builder damageScaling(DamageScaling scaling) {
            this.scaling = scaling;
            return this;
        }

        public Builder exhaustion(float exhaustion) {
            this.exhaustion = exhaustion;
            return this;
        }

        public Builder deathMessageType(DeathMessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        public DamageType build() {
            DamageType dmg = new DamageType(this.id);
            dmg.scaling = this.scaling;
            dmg.effect = this.effect;
            dmg.exhaustion = this.exhaustion;
            return dmg;
        }
    }

    @ApiStatus.Internal
    public static class Registrar {
        private RegistryComposeEvent<org.bukkit.damage.DamageType, DamageTypeRegistryEntry.Builder> event;

        public Registrar(RegistryComposeEvent<org.bukkit.damage.DamageType, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull DamageTypeRegistryEntry.Builder> event) {
            this.event = event;
        }

        public void register(List<DamageType> types) {
            types.forEach(type -> this.event.registry().register(DamageTypeKeys.create((Key)type.id.asNamespacedKey()), builder -> {
                builder.damageEffect(type.effect);
                builder.damageScaling(type.scaling);
                builder.deathMessageType(type.messageType);
                builder.messageId(type.id.toString().replace(':', '.'));
                builder.exhaustion(type.exhaustion);
            }));
        }
    }
}

