/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.entity.data;

import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.github.darksoulq.abyssallib.world.entity.data.AttributeModifier;
import com.github.darksoulq.abyssallib.world.entity.data.AttributeOperation;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Attribute<T extends Number> {
    private final String key;
    private final Class<T> type;
    private final T defaultValue;
    private final Map<Identifier, AttributeModifier<T>> modifiers = new LinkedHashMap<Identifier, AttributeModifier<T>>();

    public Attribute(String key, Class<T> type, T defaultValue) {
        this.key = key;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public String key() {
        return this.key;
    }

    public Class<T> type() {
        return this.type;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public void addModifier(Identifier id, T modifier, AttributeOperation operation) {
        if (!this.isNumericType()) {
            return;
        }
        this.modifiers.put(id, new AttributeModifier<T>(modifier, operation));
    }

    public void removeModifier(Identifier id) {
        this.modifiers.remove(id);
    }

    public Map<Identifier, AttributeModifier<T>> getModifiers() {
        return this.modifiers;
    }

    public T applyModifiers(T base) {
        if (this.modifiers.isEmpty() || base == null) {
            return base;
        }
        if (this.type == Integer.class) {
            int value = (Integer)base;
            for (AttributeModifier<T> mod : this.modifiers.values()) {
                value = mod.applyToInt(value);
            }
            return (T)Integer.valueOf(value);
        }
        if (this.type == Float.class) {
            float value = ((Float)base).floatValue();
            for (AttributeModifier<T> mod : this.modifiers.values()) {
                value = mod.applyToFloat(value);
            }
            return (T)Float.valueOf(value);
        }
        if (this.type == Double.class) {
            double value = (Double)base;
            for (AttributeModifier<T> mod : this.modifiers.values()) {
                value = mod.applyToDouble(value);
            }
            return (T)Double.valueOf(value);
        }
        if (this.type == Long.class) {
            long value = (Long)base;
            for (AttributeModifier<T> mod : this.modifiers.values()) {
                value = mod.applyToLong(value);
            }
            return (T)Long.valueOf(value);
        }
        if (this.type == Short.class) {
            short value = (Short)base;
            for (AttributeModifier<T> mod : this.modifiers.values()) {
                value = mod.applyToShort(value);
            }
            return (T)Short.valueOf(value);
        }
        if (this.type == Byte.class) {
            byte value = (Byte)base;
            for (AttributeModifier<T> mod : this.modifiers.values()) {
                value = mod.applyToByte(value);
            }
            return (T)Byte.valueOf(value);
        }
        if (this.type == BigDecimal.class) {
            BigDecimal value = (BigDecimal)base;
            for (AttributeModifier<T> mod : this.modifiers.values()) {
                value = mod.applyToBigDecimal(value);
            }
            return (T)value;
        }
        return base;
    }

    private boolean isNumericType() {
        return this.type == Integer.class || this.type == Float.class || this.type == Double.class || this.type == Long.class || this.type == Short.class || this.type == Byte.class || this.type == BigDecimal.class;
    }
}

