/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.entity.data;

import com.github.darksoulq.abyssallib.AbyssalLib;
import com.github.darksoulq.abyssallib.common.database.Database;
import com.github.darksoulq.abyssallib.common.database.impl.sqlite.SqliteDatabase;
import com.github.darksoulq.abyssallib.world.entity.data.Attribute;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class EntityAttributes {
    private static final Map<UUID, EntityAttributes> CACHE = new ConcurrentHashMap<UUID, EntityAttributes>();
    private final UUID uuid;
    private final Map<String, String> rawValues = new ConcurrentHashMap<String, String>();
    private static final Database DATABASE = new SqliteDatabase(new File(AbyssalLib.getInstance().getDataFolder(), "entity_data.db"));

    public static void init() {
        try {
            DATABASE.connect();
            EntityAttributes.initTable();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private EntityAttributes(UUID uuid) {
        this.uuid = uuid;
        this.load();
    }

    public static EntityAttributes of(Entity entity) {
        return EntityAttributes.of(entity.getUniqueId());
    }

    public static EntityAttributes of(UUID uuid) {
        return CACHE.computeIfAbsent(uuid, EntityAttributes::new);
    }

    public <T extends Number> void set(Attribute<T> attr, T value) {
        this.rawValues.put(attr.key(), value.toString());
        this.save(attr.key(), value.toString());
    }

    public boolean has(Attribute<?> attr) {
        return this.rawValues.containsKey(attr.key());
    }

    public <T extends Number> T getBaseValue(Attribute<T> attr) {
        String raw = this.rawValues.get(attr.key());
        if (raw == null) {
            return null;
        }
        return (T)((Number)this.deserialize(raw, attr.type()));
    }

    public <T extends Number> T get(Attribute<T> attr) {
        String raw = this.rawValues.get(attr.key());
        if (raw == null) {
            return null;
        }
        Number base = (Number)this.deserialize(raw, attr.type());
        return (T)attr.applyModifiers(base);
    }

    public Map<String, String> getAllAttributes() {
        return this.rawValues;
    }

    private <T> T deserialize(String value, Class<T> type) {
        try {
            if (type == Integer.class) {
                return type.cast(Integer.parseInt(value));
            }
            if (type == Double.class) {
                return type.cast(Double.parseDouble(value));
            }
            if (type == String.class) {
                return type.cast(value);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public void load() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)AbyssalLib.getInstance(), () -> {
            List<Map.Entry> rows = DATABASE.executor().table("entity_data").where("uuid = ?", this.uuid.toString()).select(rs -> Map.entry(rs.getString("key"), rs.getString("value")));
            ConcurrentHashMap<String, String> temp = new ConcurrentHashMap<String, String>();
            for (Map.Entry entry : rows) {
                temp.put((String)entry.getKey(), (String)entry.getValue());
            }
            this.rawValues.clear();
            this.rawValues.putAll(temp);
        });
    }

    private void save(String key, String value) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)AbyssalLib.getInstance(), () -> DATABASE.executor().table("entity_data").insert().value("uuid", this.uuid.toString()).value("key", key).value("value", value).execute());
    }

    public static void initTable() {
        DATABASE.executor().table("entity_data").create().ifNotExists().column("uuid", "TEXT").column("key", "TEXT").column("value", "TEXT").primaryKey("uuid", "key").execute();
    }
}

