/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.item.component;

import com.github.darksoulq.abyssallib.AbyssalLib;
import com.github.darksoulq.abyssallib.common.serialization.Codec;
import com.github.darksoulq.abyssallib.common.serialization.DynamicOps;
import com.github.darksoulq.abyssallib.common.serialization.ops.StringOps;
import com.github.darksoulq.abyssallib.common.util.CTag;
import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.github.darksoulq.abyssallib.server.registry.Registries;
import com.github.darksoulq.abyssallib.world.entity.Entity;
import com.github.darksoulq.abyssallib.world.item.Item;
import com.github.darksoulq.abyssallib.world.item.component.DataComponent;
import com.github.darksoulq.abyssallib.world.item.component.Vanilla;
import io.papermc.paper.datacomponent.DataComponentType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ComponentMap {
    private final Map<Identifier, DataComponent<?>> components = new HashMap();
    private final Map<Identifier, Vanilla> vanillaComponents = new HashMap<Identifier, Vanilla>();
    private final Item item;
    private final Entity<? extends LivingEntity> entity;

    public ComponentMap(Item item) {
        this.item = item;
        this.entity = null;
        this.load();
    }

    public ComponentMap(Entity<? extends LivingEntity> entity) {
        this.item = null;
        this.entity = null;
        this.load();
    }

    public void load() {
        if (this.item != null) {
            this.loadItem();
        }
        if (this.entity != null) {
            this.loadEntity();
        }
    }

    public void loadItem() {
        if (this.item == null || this.item.getStack() == null) {
            return;
        }
        for (DataComponentType type : this.item.getStack().getDataTypes()) {
            Class<DataComponent<?>> cls = Registries.DATA_COMPONENTS.get(type.key().toString());
            if (cls == null) continue;
            try {
                if (type instanceof DataComponentType.Valued) {
                    DataComponentType.Valued vl = (DataComponentType.Valued)type;
                    Object val = this.item.getStack().getData(vl);
                    if (val == null) continue;
                    Constructor cons = Arrays.stream(cls.getConstructors()).filter(c -> c.getParameterCount() == 1 && this.isAssignable(c.getParameterTypes()[0], val.getClass())).findFirst().orElseThrow(() -> new NoSuchMethodException("No suitable constructor for value type: " + String.valueOf(val.getClass())));
                    this.vanillaComponents.put(Identifier.of(type.key().toString()), (Vanilla)cons.newInstance(val));
                    continue;
                }
                Constructor<DataComponent<?>> cons = cls.getConstructor(new Class[0]);
                this.vanillaComponents.put(Identifier.of(type.key().toString()), (Vanilla)((Object)cons.newInstance(new Object[0])));
            }
            catch (NoSuchMethodException e) {
                AbyssalLib.getInstance().getLogger().severe("Failed to find constructor for vanilla component " + cls.getSimpleName() + ": " + e.getMessage());
            }
            catch (Exception e) {
                AbyssalLib.getInstance().getLogger().severe("Failed to instantiate vanilla component " + cls.getSimpleName() + ": " + e.getMessage());
            }
        }
        this.loadCustomComponents(this.item.getCTag());
    }

    public void loadEntity() {
        this.loadCustomComponents(this.entity.getCTag());
    }

    public void setData(DataComponent<?> component) {
        if (this.hasData(component.getId())) {
            this.removeData(component.getId());
        }
        if (component instanceof Vanilla) {
            Vanilla v = (Vanilla)((Object)component);
            this.vanillaComponents.put(component.getId(), v);
        } else {
            this.components.put(component.getId(), component);
        }
        this.applyData();
    }

    public void removeData(Identifier id) {
        if (this.vanillaComponents.containsKey(id)) {
            Vanilla v = this.vanillaComponents.remove(id);
            if (this.item != null) {
                v.remove(this.item.getStack());
            }
        } else if (this.components.containsKey(id)) {
            this.removeComponent(this.components.get(id));
        }
    }

    public void removeData(Class<? extends DataComponent> clazz) {
        for (DataComponent<?> cmp : this.components.values()) {
            if (!clazz.isInstance(cmp)) continue;
            this.components.remove(cmp.getId());
        }
        for (Vanilla v : this.vanillaComponents.values()) {
            if (!clazz.isInstance(v)) continue;
            this.vanillaComponents.remove(((DataComponent)((Object)v)).getId());
            if (this.item == null) continue;
            v.remove(this.item.getStack());
        }
    }

    public DataComponent<?> getData(Identifier id) {
        if (this.vanillaComponents.containsKey(id)) {
            return (DataComponent)((Object)this.vanillaComponents.get(id));
        }
        return this.components.getOrDefault(id, null);
    }

    public <C extends DataComponent<?>> C getData(Class<C> clazz) {
        for (DataComponent<?> cmp : this.components.values()) {
            if (!clazz.isInstance(cmp)) continue;
            return (C)cmp;
        }
        for (Vanilla v : this.vanillaComponents.values()) {
            if (!clazz.isInstance(v)) continue;
            return (C)((DataComponent)((Object)v));
        }
        return null;
    }

    public DataComponent<?> getData(DataComponentType type) {
        Identifier id = ComponentMap.getId(type);
        return (DataComponent)((Object)this.vanillaComponents.get(id));
    }

    public void applyData() {
        CTag root = this.item != null ? this.item.getCTag() : this.entity.getCTag();
        CompoundTag rootTag = root.toVanilla();
        CompoundTag tag = rootTag.getCompoundOrEmpty("CustomComponents");
        CTag data = new CTag(tag);
        data.clear();
        for (Map.Entry<Identifier, DataComponent<?>> cmp : this.components.entrySet()) {
            String encoded = ComponentMap.encodeComponent(cmp.getValue(), StringOps.INSTANCE);
            data.set(cmp.getKey().toString(), encoded);
        }
        if (this.item != null) {
            for (Vanilla v : this.vanillaComponents.values()) {
                v.apply(this.item.getStack());
            }
        }
        rootTag.put("CustomComponents", (Tag)data.toVanilla());
        if (this.item != null) {
            this.item.setCTag(root);
        }
        if (this.entity != null) {
            this.entity.setCTag(root);
        }
    }

    public boolean hasData(Identifier id) {
        return this.components.containsKey(id) || this.vanillaComponents.containsKey(id);
    }

    public boolean hasData(DataComponentType type) {
        return this.vanillaComponents.containsKey(ComponentMap.getId(type));
    }

    public <T extends DataComponent<?>> boolean hasData(Class<T> clazz) {
        return this.getData(clazz) != null;
    }

    public List<DataComponent<?>> getAllComponents() {
        ArrayList toReturn = new ArrayList();
        toReturn.addAll(this.components.values());
        toReturn.addAll(this.vanillaComponents.values().stream().map(k -> (DataComponent)((Object)k)).toList());
        return toReturn;
    }

    public List<DataComponent<?>> getVanillaComponents() {
        return new ArrayList(this.vanillaComponents.values().stream().map(k -> (DataComponent)((Object)k)).toList());
    }

    public List<DataComponent<?>> getCustomComponents() {
        return new ArrayList(this.components.values());
    }

    public List<Identifier> getAllIds() {
        ArrayList<Identifier> toReturn = new ArrayList<Identifier>();
        toReturn.addAll(this.components.keySet());
        toReturn.addAll(this.vanillaComponents.keySet());
        return toReturn;
    }

    public List<Identifier> getVanillaIds() {
        return new ArrayList<Identifier>(this.vanillaComponents.keySet());
    }

    public List<Identifier> getCustomIds() {
        return new ArrayList<Identifier>(this.components.keySet());
    }

    private void removeComponent(DataComponent<?> component) {
        CTag root = this.item != null ? this.item.getCTag() : this.entity.getCTag();
        CompoundTag rootTag = root.toVanilla();
        CompoundTag tag = rootTag.getCompoundOrEmpty("CustomComponents");
        if (tag.contains(component.getId().toString())) {
            tag.remove(component.getId().toString());
        }
        rootTag.put("CustomComponents", (Tag)tag);
        if (this.item != null) {
            this.item.setCTag(root);
        }
        if (this.entity != null) {
            this.entity.setCTag(root);
        }
    }

    public static Identifier getId(DataComponentType type) {
        return Identifier.of(type.key().asString());
    }

    private static <T, D> D encodeComponent(DataComponent<T> component, DynamicOps<D> ops) {
        try {
            return component.codec.encode(ops, component);
        }
        catch (Codec.CodecException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadCustomComponents(CTag root) {
        CompoundTag tag = root.toVanilla().getCompoundOrEmpty("CustomComponents");
        if (tag.isEmpty()) {
            return;
        }
        for (String cId : tag.keySet()) {
            Class<DataComponent<?>> cls = Registries.DATA_COMPONENTS.get(cId);
            if (cls == null) continue;
            try {
                Optional encoded = tag.getString(cId);
                if (encoded.isEmpty()) continue;
                Field codecField = cls.getDeclaredField("CODEC");
                if (!Modifier.isStatic(codecField.getModifiers())) {
                    throw new RuntimeException("Missing static CODEC in " + cls.getName());
                }
                codecField.setAccessible(true);
                Codec codec = (Codec)codecField.get(null);
                DataComponent decoded = (DataComponent)codec.decode(StringOps.INSTANCE, (String)encoded.get());
                if (decoded == null) continue;
                this.components.put(decoded.getId(), decoded);
            }
            catch (NoSuchFieldException e) {
                AbyssalLib.getInstance().getLogger().severe("Failed to find static CODEC field for custom component " + cls.getSimpleName() + ": " + e.getMessage());
            }
            catch (Codec.CodecException e) {
                AbyssalLib.getInstance().getLogger().severe("Failed to decode custom component " + cId + ": " + e.getMessage());
            }
            catch (Exception e) {
                AbyssalLib.getInstance().getLogger().severe("Failed to load custom component " + cId + ": " + e.getMessage());
            }
        }
    }

    private boolean isAssignable(Class<?> paramType, Class<?> valueType) {
        if (paramType.isPrimitive()) {
            if (paramType == Integer.TYPE && valueType == Integer.class) {
                return true;
            }
            if (paramType == Long.TYPE && valueType == Long.class) {
                return true;
            }
            if (paramType == Boolean.TYPE && valueType == Boolean.class) {
                return true;
            }
            if (paramType == Double.TYPE && valueType == Double.class) {
                return true;
            }
            if (paramType == Float.TYPE && valueType == Float.class) {
                return true;
            }
            if (paramType == Character.TYPE && valueType == Character.class) {
                return true;
            }
            if (paramType == Byte.TYPE && valueType == Byte.class) {
                return true;
            }
            return paramType == Short.TYPE && valueType == Short.class;
        }
        return paramType.isAssignableFrom(valueType);
    }
}

