/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.multiblock;

import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.github.darksoulq.abyssallib.server.event.ActionResult;
import com.github.darksoulq.abyssallib.world.multiblock.MultiblockChoice;
import com.github.darksoulq.abyssallib.world.multiblock.MultiblockEntity;
import com.github.darksoulq.abyssallib.world.multiblock.RelativeBlockPos;
import com.github.darksoulq.abyssallib.world.multiblock.internal.MultiblockManager;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class Multiblock
implements Cloneable {
    protected final Identifier id;
    protected int rotation = 0;
    protected boolean mirror = false;
    protected Location origin;
    protected MultiblockEntity entity;
    protected Map<RelativeBlockPos, MultiblockChoice> pattern = new LinkedHashMap<RelativeBlockPos, MultiblockChoice>();

    public Multiblock(Identifier id) {
        this.id = id;
    }

    public void onLoad() {
    }

    public void onUnLoad() {
    }

    public ActionResult onConstruct(Player player, Multiblock mb, ItemStack held) {
        return ActionResult.PASS;
    }

    public ActionResult onBreak(Player player, Multiblock mb, ItemStack tool) {
        return ActionResult.PASS;
    }

    public ActionResult onDestroyedByExplosion(@Nullable Entity eCause, @Nullable Block bCause) {
        return ActionResult.PASS;
    }

    public int onRedstone(int old, int now) {
        return 0;
    }

    public ActionResult onProjectileHit(Projectile projectile) {
        return ActionResult.PASS;
    }

    public abstract MultiblockChoice getTriggerChoice();

    public MultiblockEntity createMultiblockEntity(Location origin) {
        return null;
    }

    public void place(Location trigger, boolean fromDatabase) {
        this.origin = trigger;
        HashMap<Location, BlockState> snapshot = new HashMap<Location, BlockState>();
        try {
            for (Map.Entry<RelativeBlockPos, MultiblockChoice> e : this.pattern.entrySet()) {
                RelativeBlockPos rotated = Multiblock.transform(e.getKey(), this.rotation, this.mirror);
                Location abs = Multiblock.absolute(trigger, rotated);
                Block b = abs.getBlock();
                snapshot.put(abs, b.getState());
            }
            if (!fromDatabase) {
                MultiblockEntity ent = this.createMultiblockEntity(trigger);
                if (ent != null) {
                    this.setEntity(ent);
                    ent.onLoad();
                }
                MultiblockManager.register(this);
            }
        }
        catch (Throwable t) {
            for (BlockState saved : snapshot.values()) {
                try {
                    saved.update(true);
                }
                catch (Throwable throwable) {}
            }
            throw new RuntimeException(t);
        }
    }

    public int getRotation() {
        return this.rotation;
    }

    @ApiStatus.Internal
    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public boolean isMirrored() {
        return this.mirror;
    }

    @ApiStatus.Internal
    public void setMirrored(boolean mirror) {
        this.mirror = mirror;
    }

    public Location getOrigin() {
        return this.origin;
    }

    public Identifier getId() {
        return this.id;
    }

    public MultiblockEntity getEntity() {
        return this.entity;
    }

    public void setEntity(MultiblockEntity entity) {
        this.entity = entity;
    }

    public boolean isPartOfMultiblock(Location loc) {
        if (this.origin == null) {
            return false;
        }
        for (RelativeBlockPos rel : this.pattern.keySet()) {
            Location abs = Multiblock.absolute(this.origin, Multiblock.transform(rel, this.rotation, this.mirror));
            if (!abs.getWorld().equals((Object)loc.getWorld()) || abs.getBlockX() != loc.getBlockX() || abs.getBlockY() != loc.getBlockY() || abs.getBlockZ() != loc.getBlockZ()) continue;
            return true;
        }
        return false;
    }

    public boolean matchesLayout(Location trigger) {
        for (boolean mirror : new boolean[]{false, true}) {
            for (int rot = 0; rot < 4; ++rot) {
                boolean ok = true;
                for (Map.Entry<RelativeBlockPos, MultiblockChoice> e : this.pattern.entrySet()) {
                    RelativeBlockPos transformed = Multiblock.transform(e.getKey(), rot, mirror);
                    Location abs = Multiblock.absolute(trigger, transformed);
                    Block block = abs.getBlock();
                    if (MultiblockManager.isPartOfMultiblock(abs)) {
                        ok = false;
                        break;
                    }
                    if (e.getValue().matches(block)) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
                this.rotation = rot;
                this.mirror = mirror;
                return true;
            }
        }
        return false;
    }

    public Map<RelativeBlockPos, MultiblockChoice> getPattern() {
        return this.pattern;
    }

    public static Location absolute(Location origin, RelativeBlockPos rel) {
        return origin.clone().add((double)rel.x(), (double)rel.y(), (double)rel.z());
    }

    public static Multiblock from(Location location) {
        return MultiblockManager.getAt(location);
    }

    public static Multiblock from(Block block) {
        return MultiblockManager.getAt(block.getLocation());
    }

    public static boolean isPartOf(Location location) {
        return MultiblockManager.isPartOfMultiblock(location);
    }

    public static boolean isPartOf(Block block) {
        return MultiblockManager.isPartOfMultiblock(block.getLocation());
    }

    public static RelativeBlockPos transform(RelativeBlockPos p, int rot, boolean mirror) {
        int x = p.x();
        int y = p.y();
        int z = p.z();
        if (mirror) {
            x = -x;
        }
        return switch (rot & 3) {
            case 0 -> new RelativeBlockPos(x, y, z);
            case 1 -> new RelativeBlockPos(-z, y, x);
            case 2 -> new RelativeBlockPos(-x, y, -z);
            case 3 -> new RelativeBlockPos(z, y, -x);
            default -> throw new IllegalStateException();
        };
    }

    public Multiblock clone() {
        try {
            Multiblock copy = (Multiblock)super.clone();
            copy.pattern = new LinkedHashMap<RelativeBlockPos, MultiblockChoice>();
            copy.pattern.putAll(this.pattern);
            copy.mirror = this.mirror;
            copy.rotation = this.rotation;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Multiblock)) {
            return false;
        }
        Multiblock multiblock = (Multiblock)o;
        return Objects.equals(this.id, multiblock.id) && Objects.equals(this.origin, multiblock.origin);
    }
}

