/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.energy.impl;

import com.github.darksoulq.abyssallib.common.energy.Action;
import com.github.darksoulq.abyssallib.common.energy.EnergyContainer;
import com.github.darksoulq.abyssallib.common.energy.Resizable;
import com.github.darksoulq.abyssallib.common.serialization.Codec;
import com.github.darksoulq.abyssallib.common.serialization.Codecs;
import com.github.darksoulq.abyssallib.common.serialization.RecordCodecBuilder;
import com.github.darksoulq.abyssallib.server.event.EventBus;
import com.github.darksoulq.abyssallib.server.event.custom.energy.EnergyChangeEvent;

public final class SimpleEnergyContainer
implements EnergyContainer,
Resizable {
    public static final Codec<SimpleEnergyContainer> CODEC = RecordCodecBuilder.create(Codecs.DOUBLE.fieldOf("capacity", SimpleEnergyContainer::getCapacity), Codecs.DOUBLE.fieldOf("energy", SimpleEnergyContainer::getEnergy), SimpleEnergyContainer::new);
    private double energy;
    private double capacity;

    public SimpleEnergyContainer(double capacity) {
        this(capacity, 0.0);
    }

    public SimpleEnergyContainer(double capacity, double initial) {
        this.capacity = Math.max(0.0, capacity);
        this.energy = SimpleEnergyContainer.clamp(initial, 0.0, this.capacity);
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public double getCapacity() {
        return this.capacity;
    }

    @Override
    public double insert(double amount, Action action) {
        if (amount <= 0.0 || this.capacity <= 0.0) {
            return 0.0;
        }
        double space = this.capacity - this.energy;
        if (space <= 0.0) {
            return 0.0;
        }
        double toInsert = Math.min(space, amount);
        if (action.execute()) {
            double prev = this.energy;
            this.energy += toInsert;
            EventBus.post(new EnergyChangeEvent(this, prev, this.energy));
        }
        return toInsert;
    }

    @Override
    public double extract(double amount, Action action) {
        if (amount <= 0.0 || this.energy <= 0.0) {
            return 0.0;
        }
        double toExtract = Math.min(this.energy, amount);
        if (action.execute()) {
            double prev = this.energy;
            this.energy -= toExtract;
            EventBus.post(new EnergyChangeEvent(this, prev, this.energy));
        }
        return toExtract;
    }

    @Override
    public void setCapacity(double cap) {
        double newCap;
        this.capacity = newCap = Math.max(0.0, cap);
        if (this.energy > newCap) {
            double prev = this.energy;
            this.energy = newCap;
            EventBus.post(new EnergyChangeEvent(this, prev, this.energy));
        }
    }

    private static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }
}

