/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.common.serialization;

import com.github.darksoulq.abyssallib.common.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Codec<T> {
    public <D> T decode(DynamicOps<D> var1, D var2) throws CodecException;

    public <D> D encode(DynamicOps<D> var1, T var2) throws CodecException;

    public static <T> Codec<T> of(final Function<Object, T> decoder, final Function<T, Object> encoder) {
        return new Codec<T>(){

            @Override
            public <D> T decode(DynamicOps<D> ops, D input) throws CodecException {
                try {
                    return decoder.apply(input);
                }
                catch (Exception e) {
                    throw new CodecException("Failed to decode", e);
                }
            }

            @Override
            public <D> D encode(DynamicOps<D> ops, T value) throws CodecException {
                try {
                    return (D)encoder.apply(value);
                }
                catch (Exception e) {
                    throw new CodecException("Failed to encode", e);
                }
            }
        };
    }

    default public <R> Codec<R> xmap(final CheckedFunction<? super T, ? extends R> forward, final CheckedFunction<? super R, ? extends T> backward) {
        final Codec self = this;
        return new Codec<R>(this){

            @Override
            public <D> R decode(DynamicOps<D> ops, D input) throws CodecException {
                return forward.apply(self.decode(ops, input));
            }

            @Override
            public <D> D encode(DynamicOps<D> ops, R value) throws CodecException {
                return self.encode(ops, backward.apply(value));
            }
        };
    }

    default public Codec<T> orElse(final T defaultValue) {
        final Codec self = this;
        return new Codec<T>(this){

            @Override
            public <D> T decode(DynamicOps<D> ops, D input) {
                try {
                    Object result = self.decode(ops, input);
                    return result != null ? result : defaultValue;
                }
                catch (CodecException e) {
                    return defaultValue;
                }
            }

            @Override
            public <D> D encode(DynamicOps<D> ops, T value) throws CodecException {
                return self.encode(ops, value != null ? value : defaultValue);
            }
        };
    }

    default public Codec<List<T>> list() {
        final Codec self = this;
        return new Codec<List<T>>(this){

            @Override
            public <D> List<T> decode(DynamicOps<D> ops, D input) throws CodecException {
                List<D> rawList = ops.getList(input).orElseThrow(() -> new CodecException("Expected list"));
                ArrayList result = new ArrayList();
                for (D elem : rawList) {
                    result.add(self.decode(ops, elem));
                }
                return result;
            }

            @Override
            public <D> D encode(DynamicOps<D> ops, List<T> value) throws CodecException {
                ArrayList<D> result = new ArrayList<D>();
                for (Object elem : value) {
                    result.add(self.encode(ops, elem));
                }
                return ops.createList(result);
            }
        };
    }

    default public <U> Codec<U> unchecked() {
        return this;
    }

    default public Codec<Collection<T>> collection() {
        return this.collection(ArrayList::new);
    }

    default public <C extends Collection<T>> Codec<C> collection(final Supplier<C> factory) {
        final Codec self = this;
        return new Codec<C>(this){

            @Override
            public <D> C decode(DynamicOps<D> ops, D input) throws CodecException {
                List<D> rawList = ops.getList(input).orElseThrow(() -> new CodecException("Expected list for collection"));
                Collection result = (Collection)factory.get();
                for (D elem : rawList) {
                    result.add(self.decode(ops, elem));
                }
                return result;
            }

            @Override
            public <D> D encode(DynamicOps<D> ops, C value) throws CodecException {
                ArrayList<D> result = new ArrayList<D>(value.size());
                for (Object elem : value) {
                    result.add(self.encode(ops, elem));
                }
                return ops.createList(result);
            }
        };
    }

    default public Codec<Optional<T>> optional() {
        final Codec self = this;
        return new Codec<Optional<T>>(this){

            @Override
            public <D> Optional<T> decode(DynamicOps<D> ops, D input) throws CodecException {
                if (input == null || ops.empty().equals(input)) {
                    return Optional.empty();
                }
                return Optional.of(self.decode(ops, input));
            }

            @Override
            public <D> D encode(DynamicOps<D> ops, Optional<T> value) throws CodecException {
                return (D)value.map(v -> {
                    try {
                        return self.encode(ops, v);
                    }
                    catch (CodecException e) {
                        throw new RuntimeException(e);
                    }
                }).orElse(ops.empty());
            }
        };
    }

    default public Codec<T> nullable() {
        final Codec self = this;
        return new Codec<T>(this){

            @Override
            public <D> T decode(DynamicOps<D> ops, D input) throws CodecException {
                if (input == null) {
                    return null;
                }
                D empty = ops.empty();
                if (empty != null && empty.equals(input)) {
                    return null;
                }
                return self.decode(ops, input);
            }

            @Override
            public <D> D encode(DynamicOps<D> ops, T value) throws CodecException {
                return value == null ? ops.empty() : self.encode(ops, value);
            }
        };
    }

    public static <K, V> Codec<Map<K, V>> map(final Codec<K> keyCodec, final Codec<V> valueCodec) {
        return new Codec<Map<K, V>>(){

            @Override
            public <D> Map<K, V> decode(DynamicOps<D> ops, D input) throws CodecException {
                Map<D, D> rawMap = ops.getMap(input).orElseThrow(() -> new CodecException("Expected map"));
                LinkedHashMap result = new LinkedHashMap();
                for (Map.Entry<D, D> e : rawMap.entrySet()) {
                    result.put(keyCodec.decode(ops, e.getKey()), valueCodec.decode(ops, e.getValue()));
                }
                return result;
            }

            @Override
            public <D> D encode(DynamicOps<D> ops, Map<K, V> value) throws CodecException {
                LinkedHashMap<D, D> result = new LinkedHashMap<D, D>();
                for (Map.Entry e : value.entrySet()) {
                    result.put(keyCodec.encode(ops, e.getKey()), valueCodec.encode(ops, e.getValue()));
                }
                return ops.createMap(result);
            }
        };
    }

    public static <E extends Enum<E>> Codec<E> enumCodec(final Class<E> enumClass) {
        return new Codec<E>(){

            @Override
            public <D> E decode(DynamicOps<D> ops, D input) throws CodecException {
                String name = ops.getStringValue(input).orElseThrow(() -> new CodecException("Expected enum string"));
                try {
                    return Enum.valueOf(enumClass, name);
                }
                catch (IllegalArgumentException e) {
                    throw new CodecException("Invalid enum value: " + name);
                }
            }

            @Override
            public <D> D encode(DynamicOps<D> ops, E value) {
                return ops.createString(((Enum)value).name());
            }
        };
    }

    public static <T> Codec<T> either(final Codec<? extends T> left, final Codec<? extends T> right) {
        return new Codec<T>(){

            @Override
            public <D> T decode(DynamicOps<D> ops, D input) throws CodecException {
                try {
                    return left.decode(ops, input);
                }
                catch (Exception ignored) {
                    return right.decode(ops, input);
                }
            }

            @Override
            public <D> D encode(DynamicOps<D> ops, T value) throws CodecException {
                try {
                    return left.encode(ops, value);
                }
                catch (Exception ignored) {
                    return right.encode(ops, value);
                }
            }
        };
    }

    default public <P> Field<P, T> fieldOf(String name, Function<P, T> getter) {
        return new Field<P, T>(name, this, getter);
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws CodecException;
    }

    public record Field<T, A>(String name, Codec<A> codec, Function<T, A> getter) {
    }

    public static class CodecException
    extends Exception {
        public CodecException(String message) {
            super(message);
        }

        public CodecException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

