/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.bridge;

import com.github.darksoulq.abyssallib.common.util.Identifier;
import com.github.darksoulq.abyssallib.server.bridge.Provider;
import com.github.darksoulq.abyssallib.server.bridge.block.AbyssalLibProvider;
import com.github.darksoulq.abyssallib.server.bridge.block.BridgeBlock;
import com.github.darksoulq.abyssallib.server.bridge.block.MinecraftProvider;
import com.github.darksoulq.abyssallib.server.bridge.block.NexoBlockProvider;
import java.util.HashMap;
import java.util.Map;

public class BlockBridge {
    private static final Map<String, Provider<BridgeBlock<?>>> PROVIDERS = new HashMap();

    public static void setup() {
        BlockBridge.register(new MinecraftProvider());
        BlockBridge.register(new AbyssalLibProvider());
        BlockBridge.register(new NexoBlockProvider());
    }

    public static boolean hasProvider(String id) {
        String[] parts = id.split(":", 3);
        if (!Identifier.isValid2Part(id) && !Identifier.isValid3Part(id)) {
            return false;
        }
        return PROVIDERS.containsKey(parts[0]);
    }

    public static boolean hasProvider(BridgeBlock<?> block) {
        for (Provider<BridgeBlock<?>> prov : PROVIDERS.values()) {
            if (!prov.belongs(block)) continue;
            return true;
        }
        return false;
    }

    public static BridgeBlock<?> get(String id) {
        if (Identifier.isValid(id)) {
            String[] parts = id.split(":", 3);
            if (parts.length == 2) {
                return BlockBridge.get(Identifier.of(parts[0], parts[1]));
            }
            return BlockBridge.get(Identifier.of(parts[0], parts[1], parts[2]));
        }
        return null;
    }

    public static BridgeBlock<?> get(Identifier id) {
        if (!PROVIDERS.containsKey(id.getKey()) && !PROVIDERS.containsKey(id.getNamespace())) {
            return null;
        }
        Provider<BridgeBlock<?>> prov = PROVIDERS.get(id.getKey() == null ? id.getNamespace() : id.getKey());
        return prov.get(id);
    }

    public static void register(Provider<BridgeBlock<?>> provider) {
        PROVIDERS.put(provider.getPrefix(), provider);
    }
}

