/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.resource.asset;

import com.github.darksoulq.abyssallib.common.util.TextUtil;
import com.github.darksoulq.abyssallib.server.resource.asset.Asset;
import com.github.darksoulq.abyssallib.server.resource.asset.Texture;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Equipment
implements Asset {
    @NotNull
    private final String namespace;
    @NotNull
    private final String id;
    private final byte[] rawData;
    private final Map<String, List<LayerEntry>> layers = new LinkedHashMap<String, List<LayerEntry>>();

    public Equipment(@NotNull Plugin plugin, @NotNull String namespace, @NotNull String id) {
        byte[] data;
        this.namespace = namespace;
        this.id = id;
        try (InputStream in = plugin.getResource("resourcepack/" + namespace + "/equipment/" + id + ".json");){
            if (in == null) {
                throw new IllegalStateException("Equipment file not found");
            }
            data = in.readAllBytes();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load equipment JSON", e);
        }
        this.rawData = data;
    }

    public Equipment(@NotNull String namespace, @NotNull String id) {
        this.namespace = namespace;
        this.id = id;
        this.rawData = null;
    }

    public Equipment(@NotNull String namespace, @NotNull String id, byte[] data) {
        this.namespace = namespace;
        this.id = id;
        this.rawData = data;
    }

    public Equipment addLayer(@NotNull String layerType, @NotNull LayerEntry entry) {
        this.layers.computeIfAbsent(layerType, k -> new ArrayList()).add(entry);
        return this;
    }

    @Override
    public void emit(@NotNull Map<String, byte[]> files) {
        if (this.rawData != null) {
            files.put(this.path(), this.rawData);
            return;
        }
        JsonObject root = new JsonObject();
        JsonObject layersObj = new JsonObject();
        for (Map.Entry<String, List<LayerEntry>> entry : this.layers.entrySet()) {
            JsonArray arr = new JsonArray();
            for (LayerEntry le : entry.getValue()) {
                JsonObject obj = new JsonObject();
                obj.addProperty("texture", le.texture());
                if (le.usePlayerTexture != null) {
                    obj.addProperty("use_player_texture", le.usePlayerTexture);
                }
                if (le.dyeable != null) {
                    JsonObject dye = new JsonObject();
                    if (le.dyeable.colorWhenUndyed != null) {
                        dye.addProperty("color_when_undyed", (Number)le.dyeable.colorWhenUndyed);
                    }
                    obj.add("dyeable", (JsonElement)dye);
                }
                arr.add((JsonElement)obj);
            }
            layersObj.add(entry.getKey(), (JsonElement)arr);
        }
        root.add("layers", (JsonElement)layersObj);
        files.put(this.path(), TextUtil.GSON.toJson((JsonElement)root).getBytes(StandardCharsets.UTF_8));
    }

    private String path() {
        return "assets/" + this.namespace + "/equipment/" + this.id + ".json";
    }

    public static class LayerEntry {
        private final Texture texture;
        private Boolean usePlayerTexture;
        private Dyeable dyeable;

        public LayerEntry(@NotNull Texture texture) {
            this.texture = texture;
        }

        public LayerEntry usePlayerTexture(boolean b) {
            this.usePlayerTexture = b;
            return this;
        }

        public LayerEntry dyeable(Integer colorWhenUndyed) {
            this.dyeable = new Dyeable(colorWhenUndyed);
            return this;
        }

        public String texture() {
            return this.texture.file();
        }
    }

    private static class Dyeable {
        final Integer colorWhenUndyed;

        Dyeable(Integer c) {
            this.colorWhenUndyed = c;
        }
    }
}

