/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.server.resource.asset;

import com.github.darksoulq.abyssallib.server.resource.asset.Asset;
import java.io.InputStream;
import java.util.Map;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class Texture
implements Asset {
    @NotNull
    private final String path;
    @NotNull
    private final String namespace;
    private final byte @NotNull [] data;

    public Texture(@NotNull Plugin plugin, @NotNull String namespace, @NotNull String path) {
        this.namespace = namespace;
        this.path = path;
        try (InputStream in = plugin.getResource("resourcepack/" + namespace + "/textures/" + path + ".png");){
            if (in == null) {
                throw new RuntimeException("Texture not found: " + path);
            }
            this.data = in.readAllBytes();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load texture: " + path, e);
        }
    }

    public Texture(@NotNull String namespace, @NotNull String path, @NotNull byte[] data) {
        this.namespace = namespace;
        this.path = path;
        this.data = data;
    }

    @NotNull
    public String file() {
        return this.namespace + ":" + this.path;
    }

    public byte @NotNull [] data() {
        return this.data;
    }

    @Override
    public void emit(@NotNull Map<String, byte[]> files) {
        files.put("assets/" + this.namespace + "/textures/" + this.path + ".png", this.data);
    }
}

