/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.block;

import com.github.darksoulq.abyssallib.common.serialization.DynamicOps;
import com.github.darksoulq.abyssallib.world.block.CustomBlock;
import com.github.darksoulq.abyssallib.world.block.property.Property;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class BlockEntity {
    private final CustomBlock block;

    public BlockEntity(CustomBlock block) {
        this.block = block;
    }

    public CustomBlock getBlock() {
        return this.block;
    }

    public void serverTick() {
    }

    public void randomTick() {
    }

    public void onLoad() {
    }

    public void onSave() {
    }

    public <D> D serialize(DynamicOps<D> ops) throws Exception {
        LinkedHashMap<D, D> map = new LinkedHashMap<D, D>();
        for (Field field : this.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            Object obj = field.get(this);
            if (!(obj instanceof Property)) continue;
            Property prop = (Property)obj;
            D encoded = prop.encode(ops);
            map.put(ops.createString(field.getName()), encoded);
        }
        return ops.createMap(map);
    }

    public <D> void deserialize(DynamicOps<D> ops, D input) throws Exception {
        Map map = ops.getMap(input).orElse(Map.of());
        for (Field field : this.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            Object obj = field.get(this);
            if (!(obj instanceof Property)) continue;
            Property prop = (Property)obj;
            Object encoded = map.get(ops.createString(field.getName()));
            if (encoded == null) continue;
            prop.decode(ops, encoded);
        }
    }
}

