/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.block;

public class BlockProperties {
    public final float hardness;
    public final boolean requireSilkTouch;
    public final boolean allowFortune;

    private BlockProperties(float hardness, boolean requireSilkTouch, boolean allowFortune) {
        this.hardness = hardness;
        this.requireSilkTouch = requireSilkTouch;
        this.allowFortune = allowFortune;
    }

    public static Builder of() {
        return new Builder();
    }

    public static class Builder {
        private float hardness = 1.0f;
        private boolean requireSilkTouch = false;
        private boolean allowFortune = false;

        public Builder hardness(float value) {
            this.hardness = value;
            return this;
        }

        public Builder requireSilkTouch(boolean value) {
            this.requireSilkTouch = value;
            return this;
        }

        public Builder allowFortune(boolean value) {
            this.allowFortune = value;
            return this;
        }

        public BlockProperties build() {
            return new BlockProperties(this.hardness, this.requireSilkTouch, this.allowFortune);
        }
    }
}

