/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.block.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.github.darksoulq.abyssallib.AbyssalLib;
import com.github.darksoulq.abyssallib.common.database.Database;
import com.github.darksoulq.abyssallib.common.database.impl.sqlite.SqliteDatabase;
import com.github.darksoulq.abyssallib.common.serialization.ops.JsonOps;
import com.github.darksoulq.abyssallib.common.util.TextUtil;
import com.github.darksoulq.abyssallib.server.registry.Registries;
import com.github.darksoulq.abyssallib.world.block.BlockEntity;
import com.github.darksoulq.abyssallib.world.block.CustomBlock;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;

public class BlockManager {
    public static final Map<String, CustomBlock> BLOCKS = new HashMap<String, CustomBlock>();
    public static final List<CustomBlock> ACTIVE_BLOCKS = new ArrayList<CustomBlock>();
    public static final List<CustomBlock> INACTIVE_BLOCKS = new ArrayList<CustomBlock>();
    private static Database DATABASE;

    public static void load() {
        try {
            DATABASE = new SqliteDatabase(new File(AbyssalLib.getInstance().getDataFolder(), "blocks.db"));
            DATABASE.connect();
            DATABASE.executor().table("blocks").create().ifNotExists().column("world", "TEXT").column("x", "INTEGER").column("y", "INTEGER").column("z", "INTEGER").column("block_id", "TEXT").column("data_json", "TEXT").execute();
            TextUtil.buildGson();
            List<BlockRow> rows = DATABASE.executor().table("blocks").select(rs -> {
                String world = rs.getString("world");
                int x = rs.getInt("x");
                int y = rs.getInt("y");
                int z = rs.getInt("z");
                String blockId = rs.getString("block_id");
                String dataJson = rs.getString("data_json");
                return new BlockRow(world, x, y, z, blockId, dataJson);
            });
            for (BlockRow row : rows) {
                Location loc = new Location(Bukkit.getWorld((String)row.world), (double)row.x, (double)row.y, (double)row.z);
                CustomBlock block = Registries.BLOCKS.get(row.blockId).clone();
                if (block == null) {
                    AbyssalLib.getInstance().getLogger().warning("Unknown block id in DB: " + row.blockId);
                    continue;
                }
                block.place(loc.getBlock(), true);
                BlockEntity entity = block.createBlockEntity(loc);
                if (entity != null) {
                    entity.deserialize(JsonOps.INSTANCE, new JsonMapper().readTree(row.dataJson));
                    entity.onLoad();
                    block.setEntity(entity);
                }
                BLOCKS.put(BlockManager.locKey(loc), block);
                if (loc.isChunkLoaded()) {
                    ACTIVE_BLOCKS.add(block);
                    continue;
                }
                INACTIVE_BLOCKS.add(block);
            }
        }
        catch (Exception e) {
            AbyssalLib.getInstance().getLogger().severe("Failed to load block database: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void register(CustomBlock block) {
        Location loc = block.getLocation();
        if (loc == null) {
            return;
        }
        BLOCKS.put(BlockManager.locKey(loc), block);
        ACTIVE_BLOCKS.add(block);
        BlockManager.save(block);
    }

    public static CustomBlock get(Location loc) {
        return BLOCKS.get(BlockManager.locKey(loc));
    }

    public static void remove(Location loc, CustomBlock block) {
        BLOCKS.remove(BlockManager.locKey(loc));
        ACTIVE_BLOCKS.remove(block);
        try {
            DATABASE.executor().table("blocks").delete().where("world", loc.getWorld().getName()).where("x", loc.getBlockX()).where("y", loc.getBlockY()).where("z", loc.getBlockZ()).execute();
        }
        catch (Exception e) {
            AbyssalLib.getInstance().getLogger().warning("Failed to remove block: " + e.getMessage());
        }
    }

    public static void save(CustomBlock block) {
        try {
            String json;
            Location loc = block.getLocation();
            if (loc == null) {
                return;
            }
            BlockEntity entity = block.getEntity();
            if (entity != null) {
                entity.onSave();
                JsonNode node = entity.serialize(JsonOps.INSTANCE);
                json = node.toString();
            } else {
                json = "{}";
            }
            DATABASE.executor().table("blocks").insert().value("world", loc.getWorld().getName()).value("x", loc.getBlockX()).value("y", loc.getBlockY()).value("z", loc.getBlockZ()).value("block_id", block.getId().toString()).value("data_json", json).execute();
        }
        catch (Exception e) {
            AbyssalLib.getInstance().getLogger().warning("Failed to save block: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static int save() {
        int saved = 0;
        for (CustomBlock block : BLOCKS.values()) {
            BlockManager.save(block);
            ++saved;
        }
        return saved;
    }

    public static List<CustomBlock> getBlocksInChunk(Chunk chunk) {
        ArrayList<CustomBlock> blocks = new ArrayList<CustomBlock>();
        String worldName = chunk.getWorld().getName();
        for (CustomBlock block : BLOCKS.values()) {
            Location loc = block.getLocation();
            if (!loc.getWorld().getName().equals(worldName)) continue;
            int cx = loc.getBlockX() >> 4;
            int cz = loc.getBlockZ() >> 4;
            if (cx != chunk.getX() || cz != chunk.getZ()) continue;
            blocks.add(block);
        }
        return blocks;
    }

    private static String locKey(Location loc) {
        return loc.getWorld().getName() + ":" + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    private static class BlockRow {
        final String world;
        final int x;
        final int y;
        final int z;
        final String blockId;
        final String dataJson;

        public BlockRow(String world, int x, int y, int z, String blockId, String dataJson) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.blockId = blockId;
            this.dataJson = dataJson;
        }
    }
}

