/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.data.loot;

import com.github.darksoulq.abyssallib.world.data.loot.LootCondition;
import com.github.darksoulq.abyssallib.world.data.loot.LootContext;
import com.github.darksoulq.abyssallib.world.data.loot.LootEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.inventory.ItemStack;

public class LootPool {
    private final List<LootEntry> entries = new ArrayList<LootEntry>();
    private final int rolls;
    private final List<LootCondition> conditions = new ArrayList<LootCondition>();

    public LootPool(int rolls) {
        this.rolls = rolls;
    }

    public LootPool addEntry(LootEntry entry) {
        this.entries.add(entry);
        return this;
    }

    public LootPool when(LootCondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public List<ItemStack> generate(LootContext context) {
        if (!this.conditions.stream().allMatch(cond -> cond.test(context))) {
            return List.of();
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        Random random = context.getRandom();
        for (int i = 0; i < this.rolls; ++i) {
            LootEntry entry = this.entries.get(random.nextInt(this.entries.size()));
            result.addAll(entry.generate(context));
        }
        return result;
    }
}

