/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.data.statistic;

import com.github.darksoulq.abyssallib.common.util.Identifier;

public abstract class Statistic {
    private final Identifier id;

    protected Statistic(Identifier id) {
        this.id = id;
    }

    public Identifier getId() {
        return this.id;
    }

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract Statistic clone();

    public static IntStatistic of(Identifier id, int defaultValue) {
        return new IntStatistic(id, defaultValue);
    }

    public static FloatStatistic of(Identifier id, float defaultValue) {
        return new FloatStatistic(id, defaultValue);
    }

    public static BooleanStatistic of(Identifier id, boolean defaultValue) {
        return new BooleanStatistic(id, defaultValue);
    }

    public static final class IntStatistic
    extends Statistic {
        private int value;

        private IntStatistic(Identifier id, int defaultValue) {
            super(id);
            this.value = defaultValue;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public void setValue(Object value) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("Expected Integer");
            }
            Integer i = (Integer)value;
            this.value = i;
        }

        @Override
        public IntStatistic clone() {
            return new IntStatistic(this.getId(), this.value);
        }
    }

    public static final class FloatStatistic
    extends Statistic {
        private float value;

        private FloatStatistic(Identifier id, float defaultValue) {
            super(id);
            this.value = defaultValue;
        }

        @Override
        public Float getValue() {
            return Float.valueOf(this.value);
        }

        @Override
        public void setValue(Object value) {
            if (!(value instanceof Float)) {
                throw new IllegalArgumentException("Expected Float");
            }
            Float f = (Float)value;
            this.value = f.floatValue();
        }

        @Override
        public FloatStatistic clone() {
            return new FloatStatistic(this.getId(), this.value);
        }
    }

    public static final class BooleanStatistic
    extends Statistic {
        private boolean value;

        private BooleanStatistic(Identifier id, boolean defaultValue) {
            super(id);
            this.value = defaultValue;
        }

        @Override
        public Boolean getValue() {
            return this.value;
        }

        @Override
        public void setValue(Object value) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("Expected Boolean");
            }
            Boolean b = (Boolean)value;
            this.value = b;
        }

        @Override
        public BooleanStatistic clone() {
            return new BooleanStatistic(this.getId(), this.value);
        }
    }
}

