/*
 * Decompiled with CFR 0.152.
 */
package com.github.darksoulq.abyssallib.world.gui.impl;

import com.github.darksoulq.abyssallib.world.gui.Gui;
import com.github.darksoulq.abyssallib.world.gui.GuiElement;
import com.github.darksoulq.abyssallib.world.gui.GuiLayer;
import com.github.darksoulq.abyssallib.world.gui.GuiView;
import com.github.darksoulq.abyssallib.world.gui.SlotPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.inventory.Inventory;

public class PaginatedElements
implements GuiLayer {
    private final int[] slots;
    private final GuiView.Segment segment;
    private final List<GuiElement> source;
    private List<GuiElement> filtered;
    private Predicate<GuiElement> filter = el -> true;
    private int page = 0;
    private int lastRenderedPage = -1;

    public PaginatedElements(List<GuiElement> source, int[] slots, GuiView.Segment segment) {
        this.source = new ArrayList<GuiElement>(source);
        this.slots = slots;
        this.segment = segment;
        this.filtered = source.stream().filter(this.filter).toList();
    }

    public void setFilter(Predicate<GuiElement> filter) {
        this.filter = filter;
        this.filtered = this.source.stream().filter(filter).toList();
        this.page = 0;
        this.lastRenderedPage = -1;
    }

    public void next(GuiView view) {
        if (this.pageCount() <= 0) {
            return;
        }
        int newPage = (this.page + 1) % this.pageCount();
        if (newPage != this.page) {
            this.page = newPage;
            this.cleanup(view);
        }
    }

    public void prev(GuiView view) {
        if (this.pageCount() <= 0) {
            return;
        }
        int newPage = (this.page - 1 + this.pageCount()) % this.pageCount();
        if (newPage != this.page) {
            this.page = newPage;
            this.cleanup(view);
        }
    }

    public int pageCount() {
        return (int)Math.ceil((double)this.filtered.size() / (double)this.slots.length);
    }

    public int getPage() {
        return this.page;
    }

    @Override
    public void renderTo(GuiView view) {
        int global;
        if (this.page == this.lastRenderedPage) {
            return;
        }
        this.cleanup(view);
        Gui gui = view.getGui();
        int start = this.page * this.slots.length;
        for (int i = 0; i < this.slots.length && (global = start + i) < this.filtered.size(); ++i) {
            int slot = this.slots[i];
            GuiElement el = this.filtered.get(global);
            SlotPosition pos = new SlotPosition(this.segment, slot);
            gui.getElements().put(pos, el);
        }
        this.lastRenderedPage = this.page;
    }

    @Override
    public void cleanup(GuiView view) {
        Inventory inv = this.segment == GuiView.Segment.TOP ? view.getTop() : view.getBottom();
        for (int slot : this.slots) {
            view.getGui().getElements().remove(new SlotPosition(this.segment, slot));
            inv.setItem(slot, null);
        }
    }
}

